/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.TemporalAdjuster;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.connect.data.Field;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class MySqlValueConvertersTest {
    private static final TemporalAdjuster ADJUSTER = MySqlValueConverters::adjustTemporal;
    private static final byte[] INVALID_JSON = new byte[]{2, 1, 0, 91, 0, 0, 7, 0, 2, 0, 84, 0, 18, 0, 4, 0, 22, 0, 6, 0, 12, 28, 0, 0, 47, 0, 116, 121, 112, 101};

    @Test
    public void shouldAdjustLocalDateWithTwoDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(0))).isEqualTo((Object)this.localDateWithYear(2000));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(1))).isEqualTo((Object)this.localDateWithYear(2001));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(10))).isEqualTo((Object)this.localDateWithYear(2010));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(69))).isEqualTo((Object)this.localDateWithYear(2069));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(70))).isEqualTo((Object)this.localDateWithYear(1970));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(71))).isEqualTo((Object)this.localDateWithYear(1971));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(99))).isEqualTo((Object)this.localDateWithYear(1999));
    }

    @Test
    public void shouldAdjustLocalDateTimeWithTwoDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(0))).isEqualTo((Object)this.localDateTimeWithYear(2000));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(1))).isEqualTo((Object)this.localDateTimeWithYear(2001));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(10))).isEqualTo((Object)this.localDateTimeWithYear(2010));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(69))).isEqualTo((Object)this.localDateTimeWithYear(2069));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(70))).isEqualTo((Object)this.localDateTimeWithYear(1970));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(71))).isEqualTo((Object)this.localDateTimeWithYear(1971));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(99))).isEqualTo((Object)this.localDateTimeWithYear(1999));
    }

    @Test
    public void shouldNotAdjustLocalDateWithThreeDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(-1))).isEqualTo((Object)this.localDateWithYear(-1));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(100))).isEqualTo((Object)this.localDateWithYear(100));
    }

    @Test
    public void shouldNotAdjustLocalDateTimeWithThreeDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(-1))).isEqualTo((Object)this.localDateTimeWithYear(-1));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(100))).isEqualTo((Object)this.localDateTimeWithYear(100));
    }

    @Test
    public void testJsonValues() {
        String sql = "CREATE TABLE JSON_TABLE (    A JSON,    B JSON NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "JSON_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).optional().build());
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"{}")).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"[]")).isEqualTo((Object)"[]");
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)new byte[0])).isNull();
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert(null)).isNull();
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }")).isEqualTo((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }");
        Column colB = table.columnWithName("B");
        Field fieldB = new Field(colB.name(), -1, converters.schemaBuilder(colB).build());
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"{}")).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"[]")).isEqualTo((Object)"[]");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)new byte[0])).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert(null)).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }")).isEqualTo((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }");
    }

    @Test
    @FixFor(value={"DBZ-2563"})
    public void testSkipInvalidJsonValues() {
        AtomicInteger errorCount = new AtomicInteger(0);
        String sql = "CREATE TABLE JSON_TABLE (    A JSON,    B JSON NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, x -> x, (message, exception) -> errorCount.incrementAndGet());
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "JSON_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).optional().build());
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)INVALID_JSON)).isEqualTo(null);
        Assertions.assertThat((int)errorCount.get()).isEqualTo(1);
        Column colB = table.columnWithName("B");
        Field fieldB = new Field(colB.name(), -1, converters.schemaBuilder(colB).build());
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)INVALID_JSON)).isEqualTo((Object)"{}");
        Assertions.assertThat((int)errorCount.get()).isEqualTo(2);
    }

    @Test(expected=DebeziumException.class)
    @FixFor(value={"DBZ-2563"})
    public void testErrorOnInvalidJsonValues() {
        String sql = "CREATE TABLE JSON_TABLE (    A JSON,    B JSON NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, x -> x, (message, exception) -> {
            throw new DebeziumException(message, (Throwable)exception);
        });
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "JSON_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).optional().build());
        converters.converter(colA, fieldA).convert((Object)INVALID_JSON);
    }

    @Test
    @FixFor(value={"DBC-3371"})
    public void testFallbackDecimalValueScale() {
        int scale = 42;
        String sql = "CREATE TABLE DECIMAL_TABLE (A DECIMAL(3, " + scale + ") NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, x -> x, (message, exception) -> {
            throw new DebeziumException(message, (Throwable)exception);
        });
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "DECIMAL_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).build());
        Assert.assertEquals((Object)BigDecimal.ZERO.setScale(scale), (Object)converters.converter(colA, fieldA).convert(null));
    }

    protected LocalDate localDateWithYear(int year) {
        return LocalDate.of(year, Month.APRIL, 4);
    }

    protected LocalDateTime localDateTimeWithYear(int year) {
        return LocalDateTime.of(year, Month.APRIL, 4, 0, 0, 0);
    }
}

