/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.junit;

import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.junit.SkipWhenGtidModeIs;
import io.debezium.junit.AnnotationBasedTestRule;
import java.sql.SQLException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnGtidModeRule
extends AnnotationBasedTestRule {
    private static final SkipWhenGtidModeIs.GtidMode gtidMode = SkipTestDependingOnGtidModeRule.getGtidMode();

    public Statement apply(Statement base, Description description) {
        SkipWhenGtidModeIs skipGtidMode = (SkipWhenGtidModeIs)this.hasAnnotation(description, SkipWhenGtidModeIs.class);
        if (skipGtidMode != null && skipGtidMode.value().equals((Object)gtidMode)) {
            String reasonForSkipping = "GTID_MODE is " + skipGtidMode.value() + System.lineSeparator() + skipGtidMode.reason();
            return SkipTestDependingOnGtidModeRule.emptyStatement((String)reasonForSkipping, (Description)description);
        }
        return base;
    }

    public static SkipWhenGtidModeIs.GtidMode getGtidMode() {
        SkipWhenGtidModeIs.GtidMode gtidMode;
        block8: {
            MySqlTestConnection db = MySqlTestConnection.forTestDatabase("emptydb");
            try {
                gtidMode = (SkipWhenGtidModeIs.GtidMode)((Object)db.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                    if (rs.next()) {
                        return SkipWhenGtidModeIs.GtidMode.valueOf(rs.getString(2));
                    }
                    throw new IllegalStateException("Cannot obtain GTID status");
                }));
                if (db == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (db != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Cannot obtain GTID status", e);
                }
            }
            db.close();
        }
        return gtidMode;
    }
}

