/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlFloatIT
extends AbstractConnectorTest {
    private static final String TABLE_NAME = "DBZ3865";
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-float.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("floatit", "float_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-3865"})
    public void shouldHandleFloatAsFloatAndDouble() throws SQLException, InterruptedException {
        String includeTables = Collect.arrayListOf((Object)this.DATABASE.qualifiedTableName(TABLE_NAME), (Object[])new String[]{this.DATABASE.qualifiedTableName("DBZ3865_2")}).stream().collect(Collectors.joining(","));
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, includeTables)).build();
        this.start(MySqlConnector.class, this.config);
        this.assertFloatChangeRecord(this.consumeInsert());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection conn = db.connect();){
            String createDdl = "CREATE TABLE `DBZ3865_2` (\n  `id` INT NOT NULL AUTO_INCREMENT,\n  `f1` FLOAT DEFAULT 5.6,\n  `f2` FLOAT(10, 2) DEFAULT NULL,\n  `f3` FLOAT(35, 5) DEFAULT NULL,\n  `f4_23` FLOAT(23) DEFAULT NULL,\n  `f4_24` FLOAT(24) DEFAULT NULL,\n  `f4_25` FLOAT(25) DEFAULT NULL,\n  PRIMARY KEY (`ID`)\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;";
            String insertDml = "INSERT INTO DBZ3865_2(f1, f2, f3, f4_23, f4_24, f4_25) VALUE (5.6, 5.61, 30.123456, 64.1, 64.1, 64.1);";
            conn.execute(new String[]{createDdl, insertDml});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((Object)records).isNotNull();
        List events = records.recordsForTopic(this.DATABASE.topicForTable("DBZ3865_2"));
        this.assertFloatChangeRecord((SourceRecord)events.get(0));
        this.stopConnector();
    }

    private SourceRecord consumeInsert() throws InterruptedException {
        int numDatabase = 2;
        int numTables = 4;
        boolean numOthers = true;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        Assertions.assertThat((Object)records).isNotNull();
        List events = records.recordsForTopic(this.DATABASE.topicForTable(TABLE_NAME));
        Assertions.assertThat((List)events).hasSize(1);
        return (SourceRecord)events.get(0);
    }

    private void assertFloatChangeRecord(SourceRecord sourceRecord) {
        Assertions.assertThat((Object)sourceRecord).isNotNull();
        Struct change = ((Struct)sourceRecord.value()).getStruct("after");
        float f2 = 5.61f;
        float f3 = 30.12346f;
        Assertions.assertThat((Float)change.getFloat32("f1")).isEqualTo(5.6f);
        Assertions.assertThat((Double)change.getFloat64("f2")).isEqualTo((Object)((Number)Float.valueOf(5.61f)).doubleValue());
        Assertions.assertThat((Double)change.getFloat64("f3")).isEqualTo((Object)((Number)Float.valueOf(30.12346f)).doubleValue());
        Assertions.assertThat((Float)change.getFloat32("f4_23")).isEqualTo(64.1f);
        Assertions.assertThat((Float)change.getFloat32("f4_24")).isEqualTo(64.1f);
        Assertions.assertThat((Double)change.getFloat64("f4_25")).isEqualTo(64.1);
    }
}

