/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr.listener;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.connector.mysql.antlr.listener.ColumnDefinitionParserListener;
import io.debezium.connector.mysql.antlr.listener.DefaultValueParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.text.ParsingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableParserListener
extends MySqlParserBaseListener {
    private static final int STARTING_INDEX = 1;
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableParserListener.class);
    private final MySqlAntlrDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private ColumnEditor defaultValueColumnEditor;
    private ColumnDefinitionParserListener columnDefinitionListener;
    private DefaultValueParserListener defaultValueListener;
    private List<ColumnEditor> columnEditors;
    private int parsingColumnIndex = 1;

    public AlterTableParserListener(MySqlAntlrDdlParser parser, List<ParseTreeListener> listeners) {
        this.parser = parser;
        this.listeners = listeners;
    }

    public void enterAlterTable(MySqlParser.AlterTableContext ctx) {
        TableId tableId = this.parser.parseQualifiedTableId(ctx.tableName().fullId());
        if (this.parser.databaseTables().forTable(tableId) == null) {
            LOG.debug("Ignoring ALTER TABLE statement for non-captured table {}", (Object)tableId);
            return;
        }
        this.tableEditor = this.parser.databaseTables().editTable(tableId);
        if (this.tableEditor == null) {
            throw new ParsingException(null, "Trying to alter table " + tableId.toString() + ", which does not exist. Query: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
        }
        super.enterAlterTable(ctx);
    }

    public void exitAlterTable(MySqlParser.AlterTableContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.listeners.remove((Object)this.columnDefinitionListener);
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.parser.signalAlterTable(this.tableEditor.tableId(), null, ctx.getParent());
        }, this.tableEditor);
        super.exitAlterTable(ctx);
        this.tableEditor = null;
    }

    public void enterAlterByAddColumn(MySqlParser.AlterByAddColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            String columnName = this.parser.parseName(ctx.uid(0));
            ColumnEditor columnEditor = Column.editor().name(columnName);
            this.columnDefinitionListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
            this.listeners.add((ParseTreeListener)this.columnDefinitionListener);
        }, this.tableEditor);
        super.exitAlterByAddColumn(ctx);
    }

    public void exitAlterByAddColumn(MySqlParser.AlterByAddColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            this.tableEditor.addColumn(column);
            String columnName = column.name();
            if (ctx.FIRST() != null) {
                this.tableEditor.reorderColumn(columnName, null);
            } else if (ctx.AFTER() != null) {
                String afterColumn = this.parser.parseName(ctx.uid(1));
                this.tableEditor.reorderColumn(columnName, afterColumn);
            }
            this.listeners.remove((Object)this.columnDefinitionListener);
        }, new Object[]{this.tableEditor, this.columnDefinitionListener});
        super.exitAlterByAddColumn(ctx);
    }

    public void enterAlterByAddColumns(MySqlParser.AlterByAddColumnsContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.columnEditors = new ArrayList<ColumnEditor>(ctx.uid().size());
            for (MySqlParser.UidContext uidContext : ctx.uid()) {
                String columnName = this.parser.parseName(uidContext);
                this.columnEditors.add(Column.editor().name(columnName));
            }
            this.columnDefinitionListener = new ColumnDefinitionParserListener(this.tableEditor, this.columnEditors.get(0), this.parser, this.listeners);
            this.listeners.add((ParseTreeListener)this.columnDefinitionListener);
        }, this.tableEditor);
        super.enterAlterByAddColumns(ctx);
    }

    public void exitColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (this.columnEditors != null) {
                if (this.columnEditors.size() > this.parsingColumnIndex) {
                    this.columnDefinitionListener.setColumnEditor(this.columnEditors.get(this.parsingColumnIndex++));
                } else {
                    this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
                    this.columnEditors = null;
                    this.parsingColumnIndex = 1;
                }
            }
        }, this.tableEditor, this.columnEditors);
        super.exitColumnDefinition(ctx);
    }

    public void exitAlterByAddColumns(MySqlParser.AlterByAddColumnsContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
            this.listeners.remove((Object)this.columnDefinitionListener);
        }, this.tableEditor, this.columnEditors);
        super.exitAlterByAddColumns(ctx);
    }

    public void enterAlterByChangeColumn(MySqlParser.AlterByChangeColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            String oldColumnName = this.parser.parseName(ctx.oldColumn);
            Column existingColumn = this.tableEditor.columnWithName(oldColumnName);
            if (existingColumn == null) {
                throw new ParsingException(null, "Trying to change column " + oldColumnName + " in " + this.tableEditor.tableId().toString() + " table, which does not exist. Query: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
            }
            ColumnEditor columnEditor = existingColumn.edit();
            columnEditor.unsetDefaultValueExpression();
            this.columnDefinitionListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
            this.listeners.add((ParseTreeListener)this.columnDefinitionListener);
        }, this.tableEditor);
        super.enterAlterByChangeColumn(ctx);
    }

    public void exitAlterByChangeColumn(MySqlParser.AlterByChangeColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            this.tableEditor.addColumn(column);
            String newColumnName = this.parser.parseName(ctx.newColumn);
            if (newColumnName != null && !column.name().equals(newColumnName)) {
                this.tableEditor.renameColumn(column.name(), newColumnName);
            }
            if (ctx.FIRST() != null) {
                this.tableEditor.reorderColumn(newColumnName, null);
            } else if (ctx.afterColumn != null) {
                this.tableEditor.reorderColumn(newColumnName, this.parser.parseName(ctx.afterColumn));
            }
            this.listeners.remove((Object)this.columnDefinitionListener);
        }, new Object[]{this.tableEditor, this.columnDefinitionListener});
        super.exitAlterByChangeColumn(ctx);
    }

    public void enterAlterByModifyColumn(MySqlParser.AlterByModifyColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            String columnName = this.parser.parseName(ctx.uid(0));
            Column existingColumn = this.tableEditor.columnWithName(columnName);
            if (existingColumn == null) {
                throw new ParsingException(null, "Trying to change column " + columnName + " in " + this.tableEditor.tableId().toString() + " table, which does not exist. Query: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
            }
            ColumnEditor columnEditor = existingColumn.edit();
            columnEditor.unsetDefaultValueExpression();
            this.columnDefinitionListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
            this.listeners.add((ParseTreeListener)this.columnDefinitionListener);
        }, this.tableEditor);
        super.enterAlterByModifyColumn(ctx);
    }

    public void exitAlterByModifyColumn(MySqlParser.AlterByModifyColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            this.tableEditor.addColumn(column);
            if (ctx.FIRST() != null) {
                this.tableEditor.reorderColumn(column.name(), null);
            } else if (ctx.AFTER() != null) {
                String afterColumn = this.parser.parseName(ctx.uid(1));
                this.tableEditor.reorderColumn(column.name(), afterColumn);
            }
            this.listeners.remove((Object)this.columnDefinitionListener);
        }, new Object[]{this.tableEditor, this.columnDefinitionListener});
        super.exitAlterByModifyColumn(ctx);
    }

    public void enterAlterByDropColumn(MySqlParser.AlterByDropColumnContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.removeColumn(this.parser.parseName(ctx.uid())), this.tableEditor);
        super.enterAlterByDropColumn(ctx);
    }

    public void enterAlterByRename(MySqlParser.AlterByRenameContext ctx) {
        this.parser.runIfNotNull(() -> {
            TableId newTableId = ctx.uid() != null ? this.parser.resolveTableId(this.parser.currentSchema(), this.parser.parseName(ctx.uid())) : this.parser.parseQualifiedTableId(ctx.fullId());
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.parser.databaseTables().renameTable(this.tableEditor.tableId(), newTableId);
            this.tableEditor = this.parser.databaseTables().editTable(newTableId);
        }, this.tableEditor);
        super.enterAlterByRename(ctx);
    }

    public void enterAlterByChangeDefault(MySqlParser.AlterByChangeDefaultContext ctx) {
        this.parser.runIfNotNull(() -> {
            String columnName = this.parser.parseName(ctx.uid());
            Column column = this.tableEditor.columnWithName(columnName);
            if (column != null) {
                this.defaultValueColumnEditor = column.edit();
                if (ctx.SET() != null) {
                    this.defaultValueListener = new DefaultValueParserListener(this.defaultValueColumnEditor, new AtomicReference<Boolean>(column.isOptional()));
                    this.listeners.add((ParseTreeListener)this.defaultValueListener);
                } else if (ctx.DROP() != null) {
                    this.defaultValueColumnEditor.unsetDefaultValueExpression();
                }
            }
        }, this.tableEditor);
        super.enterAlterByChangeDefault(ctx);
    }

    public void exitAlterByChangeDefault(MySqlParser.AlterByChangeDefaultContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.tableEditor.updateColumn(this.defaultValueColumnEditor.create());
            this.listeners.remove((Object)this.defaultValueListener);
            this.defaultValueColumnEditor = null;
        }, this.defaultValueColumnEditor);
        super.exitAlterByChangeDefault(ctx);
    }

    public void enterAlterByAddPrimaryKey(MySqlParser.AlterByAddPrimaryKeyContext ctx) {
        this.parser.runIfNotNull(() -> this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), this.tableEditor), this.tableEditor);
        super.enterAlterByAddPrimaryKey(ctx);
    }

    public void enterAlterByDropPrimaryKey(MySqlParser.AlterByDropPrimaryKeyContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.setPrimaryKeyNames(new ArrayList()), this.tableEditor);
        super.enterAlterByDropPrimaryKey(ctx);
    }

    public void enterAlterByAddUniqueKey(MySqlParser.AlterByAddUniqueKeyContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (!this.tableEditor.hasPrimaryKey() && this.parser.isTableUniqueIndexIncluded(ctx.indexColumnNames(), this.tableEditor)) {
                this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), this.tableEditor);
            }
        }, this.tableEditor);
        super.enterAlterByAddUniqueKey(ctx);
    }

    public void enterAlterByRenameColumn(MySqlParser.AlterByRenameColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            String oldColumnName = this.parser.parseName(ctx.oldColumn);
            Column existingColumn = this.tableEditor.columnWithName(oldColumnName);
            if (existingColumn == null) {
                throw new ParsingException(null, "Trying to change column " + oldColumnName + " in " + this.tableEditor.tableId().toString() + " table, which does not exist. Query: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
            }
            ColumnEditor columnEditor = existingColumn.edit();
            this.columnDefinitionListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
            this.listeners.add((ParseTreeListener)this.columnDefinitionListener);
        }, this.tableEditor);
        super.enterAlterByRenameColumn(ctx);
    }

    public void exitAlterByRenameColumn(MySqlParser.AlterByRenameColumnContext ctx) {
        this.parser.runIfNotNull(() -> {
            Column column = this.columnDefinitionListener.getColumn();
            this.tableEditor.addColumn(column);
            String newColumnName = this.parser.parseName(ctx.newColumn);
            if (newColumnName != null && !column.name().equals(newColumnName)) {
                this.tableEditor.renameColumn(column.name(), newColumnName);
            }
            this.listeners.remove((Object)this.columnDefinitionListener);
        }, new Object[]{this.tableEditor, this.columnDefinitionListener});
        super.exitAlterByRenameColumn(ctx);
    }

    public void enterTableOptionComment(MySqlParser.TableOptionCommentContext ctx) {
        if (!this.parser.skipComments()) {
            this.parser.runIfNotNull(() -> {
                if (ctx.COMMENT() != null) {
                    this.tableEditor.setComment(MySqlAntlrDdlParser.withoutQuotes((String)ctx.STRING_LITERAL().getText()));
                }
            }, this.tableEditor);
        }
        super.enterTableOptionComment(ctx);
    }
}

