/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.TableId;
import io.debezium.schema.AbstractTopicNamingStrategy;
import io.debezium.schema.DefaultRegexTopicNamingStrategy;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.spi.schema.DataCollectionId;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigValue;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MySqlTopicNamingStrategyTest {
    @Test
    public void testDataChangeTopic() {
        TableId tableId = TableId.parse((String)"test_db.dbz_4180");
        String logicalName = "mysql-server-1";
        Properties props = new Properties();
        props.put("topic.delimiter", ".");
        props.put("logical.name", "mysql-server-1");
        DefaultTopicNamingStrategy defaultStrategy = new DefaultTopicNamingStrategy(props);
        String dataChangeTopic = defaultStrategy.dataChangeTopic((DataCollectionId)tableId);
        Assertions.assertThat((String)dataChangeTopic).isEqualTo((Object)"mysql-server-1.test_db.dbz_4180");
        String sanitizedDataChangeTopic = defaultStrategy.dataChangeTopic((DataCollectionId)TableId.parse((String)"test_db.dbz#4180#2"));
        Assertions.assertThat((String)sanitizedDataChangeTopic).isEqualTo((Object)"mysql-server-1.test_db.dbz_4180_2");
        props.put("topic.prefix", "my_prefix");
        defaultStrategy.configure(props);
        String prefixDataChangeTopic = defaultStrategy.dataChangeTopic((DataCollectionId)tableId);
        Assertions.assertThat((String)prefixDataChangeTopic).isEqualTo((Object)"my_prefix.test_db.dbz_4180");
        props.put("topic.delimiter", "_");
        defaultStrategy.configure(props);
        String delimiterDataChangeTopic = defaultStrategy.dataChangeTopic((DataCollectionId)tableId);
        Assertions.assertThat((String)delimiterDataChangeTopic).isEqualTo((Object)"my_prefix_test_db_dbz_4180");
    }

    @Test
    public void testSchemaChangeTopic() {
        String logicalName = "mysql-server-1";
        Properties props = new Properties();
        props.put("logical.name", "mysql-server-1");
        DefaultTopicNamingStrategy defaultStrategy = new DefaultTopicNamingStrategy(props);
        String schemaChangeTopic = defaultStrategy.schemaChangeTopic();
        Assertions.assertThat((String)schemaChangeTopic).isEqualTo((Object)"mysql-server-1");
        props.put("topic.prefix", "my_prefix");
        defaultStrategy.configure(props);
        String prefixSchemaChangeTopic = defaultStrategy.schemaChangeTopic();
        Assertions.assertThat((String)prefixSchemaChangeTopic).isEqualTo((Object)"my_prefix");
    }

    @Test
    public void testTransactionTopic() {
        String logicalName = "mysql-server-1";
        Properties props = new Properties();
        props.put("logical.name", "mysql-server-1");
        DefaultTopicNamingStrategy mySqlStrategy = new DefaultTopicNamingStrategy(props);
        String transactionTopic = mySqlStrategy.transactionTopic();
        String expectedTopic = "mysql-server-1.transaction";
        Assertions.assertThat((String)transactionTopic).isEqualTo((Object)expectedTopic);
    }

    @Test
    public void testHeartbeatTopic() {
        String logicalName = "mysql-server-1";
        Properties props = new Properties();
        props.put("logical.name", "mysql-server-1");
        DefaultTopicNamingStrategy mySqlStrategy = new DefaultTopicNamingStrategy(props);
        String heartbeatTopic = mySqlStrategy.heartbeatTopic();
        String expectedTopic = "__debezium-heartbeat.mysql-server-1";
        Assertions.assertThat((String)heartbeatTopic).isEqualTo((Object)expectedTopic);
    }

    @Test
    public void testLogicTableTopic() {
        TableId tableId = TableId.parse((String)"test_db.dbz_4180_01");
        String logicalName = "mysql-server-1";
        Properties props = new Properties();
        props.put("topic.delimiter", ".");
        props.put("topic.regex.enable", "true");
        props.put("topic.regex", "(.*)(dbz_4180|test)(.*)");
        props.put("topic.replacement", "$1$2_all_shards");
        props.put("logical.name", "mysql-server-1");
        DefaultRegexTopicNamingStrategy byLogicalStrategy = new DefaultRegexTopicNamingStrategy(props);
        String dataChangeTopic = byLogicalStrategy.dataChangeTopic((DataCollectionId)tableId);
        Assertions.assertThat((String)dataChangeTopic).isEqualTo((Object)"mysql-server-1.test_db.dbz_4180_all_shards");
    }

    @Test
    public void testValidateRelativeTopicNames() {
        String errorMessageSuffix = " has invalid format (only the underscore, hyphen, dot and alphanumeric characters are allowed)";
        Configuration config = ((Configuration.Builder)Configuration.create().with(AbstractTopicNamingStrategy.TOPIC_DELIMITER, "&")).build();
        List errorList = ((ConfigValue)config.validate(Field.setOf((Field[])new Field[]{AbstractTopicNamingStrategy.TOPIC_DELIMITER})).get(AbstractTopicNamingStrategy.TOPIC_DELIMITER.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)AbstractTopicNamingStrategy.TOPIC_DELIMITER, (String)("&" + errorMessageSuffix)));
        config = ((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "server@X")).build();
        errorList = ((ConfigValue)config.validate(Field.setOf((Field[])new Field[]{CommonConnectorConfig.TOPIC_PREFIX})).get(CommonConnectorConfig.TOPIC_PREFIX.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)CommonConnectorConfig.TOPIC_PREFIX, (String)("server@X" + errorMessageSuffix)));
        config = ((Configuration.Builder)Configuration.create().with(AbstractTopicNamingStrategy.TOPIC_HEARTBEAT_PREFIX, "#heartbeat#")).build();
        errorList = ((ConfigValue)config.validate(Field.setOf((Field[])new Field[]{AbstractTopicNamingStrategy.TOPIC_HEARTBEAT_PREFIX})).get(AbstractTopicNamingStrategy.TOPIC_HEARTBEAT_PREFIX.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)AbstractTopicNamingStrategy.TOPIC_HEARTBEAT_PREFIX, (String)("#heartbeat#" + errorMessageSuffix)));
        config = ((Configuration.Builder)Configuration.create().with(AbstractTopicNamingStrategy.TOPIC_TRANSACTION, "*transaction*")).build();
        errorList = ((ConfigValue)config.validate(Field.setOf((Field[])new Field[]{AbstractTopicNamingStrategy.TOPIC_TRANSACTION})).get(AbstractTopicNamingStrategy.TOPIC_TRANSACTION.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)AbstractTopicNamingStrategy.TOPIC_TRANSACTION, (String)("*transaction*" + errorMessageSuffix)));
    }
}

