/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.connector.mysql.converters.TinyIntOneToBooleanConverter;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlTinyIntIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-year.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("tinyintit", "tinyint_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1773"})
    public void shouldHandleTinyIntAsNumber() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DBZ1773"))).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeInitial();
        this.assertIntChangeRecord();
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO DBZ1773 VALUES (DEFAULT, 100, 5, 50, true)");
        }
        this.assertIntChangeRecord();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1800"})
    public void shouldHandleTinyIntOneAsBoolean() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DBZ1773"))).with(MySqlConnectorConfig.CUSTOM_CONVERTERS, "boolean")).with("boolean.type", TinyIntOneToBooleanConverter.class.getName()).with("boolean.selector", ".*DBZ1773.b").build();
        this.start(MySqlConnector.class, this.config);
        this.consumeInitial();
        this.assertBooleanChangeRecord();
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO DBZ1773 VALUES (DEFAULT, 100, 5, 50, true)");
        }
        this.assertBooleanChangeRecord();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-2085"})
    public void shouldDefaultValueForTinyIntOneAsBoolean() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DBZ2085"))).with(MySqlConnectorConfig.CUSTOM_CONVERTERS, "boolean")).with("boolean.type", TinyIntOneToBooleanConverter.class.getName()).with("boolean.selector", ".*DBZ2085.b").build();
        this.start(MySqlConnector.class, this.config);
        this.consumeInitial();
        this.assertDefaultValueBooleanChangeRecord();
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO DBZ2085 VALUES (DEFAULT, true)");
        }
        this.assertDefaultValueBooleanChangeRecord();
        this.stopConnector();
    }

    @Test
    @SkipWhenDatabaseVersion(check=EqualityCheck.GREATER_THAN_OR_EQUAL, major=8, minor=0, reason="MySQL 8 does not provide unsigned tinyint length (DBZ-5343)")
    @FixFor(value={"DBZ-5236"})
    public void shouldHandleUnsignedTinyIntOneAsBoolean() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DBZ5236"))).with(MySqlConnectorConfig.CUSTOM_CONVERTERS, "boolean")).with("boolean.type", TinyIntOneToBooleanConverter.class.getName()).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeInitial();
        this.assertUnsignedBooleanChangeRecord();
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO DBZ5236 VALUES (DEFAULT, 1, 1, 0)");
        }
        this.assertUnsignedBooleanChangeRecord();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-5343"})
    public void shouldHandleMySQL8TinyIntAsBoolean() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE, "none")).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DBZ5236"))).with(MySqlConnectorConfig.CUSTOM_CONVERTERS, "boolean")).with("boolean.type", TinyIntOneToBooleanConverter.class.getName()).with("boolean.length.checker", "false").with("boolean.selector", ".*DBZ5236.ti2,.*DBZ5236.ti3").build();
        this.start(MySqlConnector.class, this.config);
        this.consumeInitial();
        this.assertUnsignedBooleanChangeRecord();
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("INSERT INTO DBZ5236 VALUES (DEFAULT, 1, 1, 0)");
        }
        this.assertUnsignedBooleanChangeRecord();
        this.stopConnector();
    }

    private void consumeInitial() throws InterruptedException {
        int numDatabase = 2;
        int numTables = 6;
        int numOthers = 2;
        this.consumeRecords(10);
    }

    private void assertIntChangeRecord() throws InterruptedException {
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Short)change.getInt16("ti")).isEqualTo((short)100);
        Assertions.assertThat((Short)change.getInt16("ti1")).isEqualTo((short)5);
        Assertions.assertThat((Short)change.getInt16("ti2")).isEqualTo((short)50);
        Assertions.assertThat((Short)change.getInt16("b")).isEqualTo((short)1);
    }

    private void assertBooleanChangeRecord() throws InterruptedException {
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Short)change.getInt16("ti")).isEqualTo((short)100);
        Assertions.assertThat((Short)change.getInt16("ti1")).isEqualTo((short)5);
        Assertions.assertThat((Short)change.getInt16("ti2")).isEqualTo((short)50);
        Assertions.assertThat((Boolean)change.getBoolean("b")).isEqualTo(true);
    }

    private void assertDefaultValueBooleanChangeRecord() throws InterruptedException {
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Boolean)change.getBoolean("b")).isEqualTo(true);
        Assertions.assertThat((Object)change.schema().field("b").schema().defaultValue()).isEqualTo((Object)false);
    }

    private void assertUnsignedBooleanChangeRecord() throws InterruptedException {
        SourceRecord record = this.consumeRecord();
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Short)change.getInt16("ti1")).isEqualTo((short)1);
        Assertions.assertThat((Boolean)change.getBoolean("ti2")).isEqualTo(true);
        Assertions.assertThat((Boolean)change.getBoolean("ti3")).isEqualTo(false);
    }
}

