/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlSchemaNameAdjustmentModeIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-json.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("adjustment1", "schema_name_adjustment").withDbHistoryPath(SCHEMA_HISTORY_PATH);

    @Before
    public void beforeEach() throws SQLException {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void shouldAdjustNamesForAvro() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.SchemaNameAdjustmentMode.AVRO);
        Assertions.assertThat((String)data.schema().name()).contains("name_adjustment");
    }

    @Test
    public void shouldNotAdjustNames() throws InterruptedException {
        this.skipAvroValidation();
        Struct data = this.consume(CommonConnectorConfig.SchemaNameAdjustmentMode.NONE);
        Assertions.assertThat((String)data.schema().name()).contains("name-adjustment");
    }

    private Struct consume(CommonConnectorConfig.SchemaNameAdjustmentMode adjustmentMode) throws InterruptedException {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("name-adjustment"))).with(MySqlConnectorConfig.SCHEMA_NAME_ADJUSTMENT_MODE, (EnumeratedValue)adjustmentMode)).build();
        this.start(MySqlConnector.class, config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        List results = records.recordsForTopic(this.DATABASE.topicForTable("name-adjustment"));
        Assertions.assertThat((List)results).hasSize(1);
        return (Struct)((SourceRecord)results.get(0)).value();
    }
}

