/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.nio.file.Path;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlRestartIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-restart.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("restart", "connector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1276"})
    public void shouldNotDuplicateEventsAfterRestart() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("restart_table"))).build();
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE TABLE restart_table (id INT PRIMARY KEY, val INT)", "INSERT INTO restart_table VALUES(1, 10)"});
        }
        this.start(MySqlConnector.class, this.config, record -> {
            Schema schema = record.valueSchema();
            Struct value = (Struct)record.value();
            return schema.field("after") != null && value.getStruct("after").getInt32("id").equals(5);
        });
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(15);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("restart_table")).size()).isEqualTo(1);
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.connect().setAutoCommit(false);
            connection.execute(new String[]{"INSERT INTO restart_table VALUES(2,12)", "INSERT INTO restart_table VALUES(3,13)", "INSERT INTO restart_table VALUES(4,14)", "INSERT INTO restart_table VALUES(5,15)", "INSERT INTO restart_table VALUES(6,16)"});
        }
        records = this.consumeRecordsByTopic(3);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("restart_table")).size()).isEqualTo(3);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("restart_table")).get(0)).value()).getStruct("after").getInt32("id")).isEqualTo(2);
        this.stopConnector();
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("restart_table")).size()).isEqualTo(2);
        Assertions.assertThat((Integer)((Struct)((SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("restart_table")).get(0)).value()).getStruct("after").getInt32("id")).isEqualTo(5);
        this.stopConnector();
    }
}

