/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlFixedLengthBinaryColumnIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-binary-column.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("binarycolumnit", "binary_column_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-254"})
    public void bytesMode() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 4;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_254_binary_column_test"));
        Assertions.assertThat((List)dmls).hasSize(4);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Struct after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(1);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0qw==");
        insert = (SourceRecord)dmls.get(2);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(3);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((String)this.encodeToBase64String((ByteBuffer)after.get("file_uuid"))).isEqualTo((Object)"AAAAAAAAAAAAAAAAAAAAAA==");
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }

    @Test
    @FixFor(value={"DBZ-3912"})
    public void hexMode() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.HEX)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 4;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_254_binary_column_test"));
        Assertions.assertThat((List)dmls).hasSize(4);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Struct after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"651aed08390f4893b2f136923e7b7400");
        insert = (SourceRecord)dmls.get(1);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"651aed08390f4893b2f136923e7b74ab");
        insert = (SourceRecord)dmls.get(2);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"651aed08390f4893b2f136923e7b7400");
        insert = (SourceRecord)dmls.get(3);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"00000000000000000000000000000000");
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }

    @Test
    @FixFor(value={"DBZ-3912"})
    public void base64Mode() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.BASE64)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 4;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_254_binary_column_test"));
        Assertions.assertThat((List)dmls).hasSize(4);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Struct after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(1);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0qw==");
        insert = (SourceRecord)dmls.get(2);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(3);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"AAAAAAAAAAAAAAAAAAAAAA==");
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }

    @Test
    @FixFor(value={"DBZ-5544"})
    public void base64UrlSafeMode() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.BASE64_URL_SAFE)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 4;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_254_binary_column_test"));
        Assertions.assertThat((List)dmls).hasSize(4);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Struct after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(1);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0qw==");
        insert = (SourceRecord)dmls.get(2);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"ZRrtCDkPSJOy8TaSPnt0AA==");
        insert = (SourceRecord)dmls.get(3);
        after = (Struct)((Struct)insert.value()).get("after");
        Assertions.assertThat((Object)after.get("file_uuid")).isEqualTo((Object)"AAAAAAAAAAAAAAAAAAAAAA==");
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
    }

    private String encodeToBase64String(ByteBuffer bytes) {
        return Base64.getEncoder().encodeToString(bytes.array());
    }
}

