/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, patch=5, reason="MySQL does not support CURRENT_TIMESTAMP on DATETIME and only a single column can specify default CURRENT_TIMESTAMP, lifted in MySQL 5.6.5")
public class MySqlEnumColumnIT
extends AbstractConnectorTest {
    private static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    private static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    private static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-enum-column.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("enumcolumnit", "enum_column_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1203"})
    public void shouldAlterEnumColumnCharacterSet() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("test_stations_10"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        Schema schemaBeforeAlter = ((SourceRecord)records.allRecordsInOrder().get(2)).valueSchema().field("after").schema();
        Schema schemaAfterAlter = ((SourceRecord)records.allRecordsInOrder().get(4)).valueSchema().field("after").schema();
        String allowedBeforeAlter = (String)schemaBeforeAlter.field("type").schema().parameters().get("allowed");
        String allowedAfterAlter = (String)schemaAfterAlter.field("type").schema().parameters().get("allowed");
        Assertions.assertThat((String)allowedBeforeAlter).isEqualTo((Object)"station,post_office");
        Assertions.assertThat((String)allowedAfterAlter).isEqualTo((Object)"station,post_office,plane,ahihi_dongok,now,test,a\\,b,c\\,'d,g\\,'h");
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1636"})
    public void shouldPropagateColumnSourceType() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("test_stations_10"))).with("column.propagate.source.type", this.DATABASE.qualifiedTableName("test_stations_10") + ".type").build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        SourceRecord recordBefore = (SourceRecord)records.allRecordsInOrder().get(2);
        Schema schemaBeforeAlter = recordBefore.valueSchema().field("after").schema();
        Schema typeBeforeSchema = schemaBeforeAlter.field("type").schema();
        Assertions.assertThat((String)typeBeforeSchema.name()).isEqualTo((Object)"io.debezium.data.Enum");
        Map beforeParameters = typeBeforeSchema.parameters();
        Assertions.assertThat((String)((String)beforeParameters.get(TYPE_NAME_PARAMETER_KEY))).isEqualTo((Object)"ENUM");
        Assertions.assertThat((String)((String)beforeParameters.get(TYPE_LENGTH_PARAMETER_KEY))).isEqualTo((Object)"1");
        Assertions.assertThat((String)((String)beforeParameters.get(TYPE_SCALE_PARAMETER_KEY))).isNull();
        SourceRecord recordAfter = (SourceRecord)records.allRecordsInOrder().get(4);
        Schema schemaAfterAlter = recordAfter.valueSchema().field("after").schema();
        Schema typeAfterSchema = schemaAfterAlter.field("type").schema();
        Assertions.assertThat((String)typeAfterSchema.name()).isEqualTo((Object)"io.debezium.data.Enum");
        Map afterParameters = schemaAfterAlter.field("type").schema().parameters();
        Assertions.assertThat((String)((String)afterParameters.get(TYPE_NAME_PARAMETER_KEY))).isEqualTo((Object)"ENUM");
        Assertions.assertThat((String)((String)afterParameters.get(TYPE_LENGTH_PARAMETER_KEY))).isEqualTo((Object)"1");
        Assertions.assertThat((String)((String)afterParameters.get(TYPE_SCALE_PARAMETER_KEY))).isNull();
        this.stopConnector();
    }
}

