/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenKafkaVersion;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlDecimalIT
extends AbstractConnectorTest {
    private static final String TABLE_NAME = "DBZ730";
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-decimal.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("decimaldb", "decimal_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.skipAvroValidation();
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @SkipWhenKafkaVersion(value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, check=EqualityCheck.EQUAL, description="No compatible with Kafka 1.x")
    @FixFor(value={"DBZ-730"})
    public void testPreciseDecimalHandlingMode() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName(TABLE_NAME))).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.PRECISE)).build();
        this.start(MySqlConnector.class, this.config);
        this.assertBigDecimalChangeRecord(this.consumeInsert());
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-730"})
    public void testDoubleDecimalHandlingMode() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName(TABLE_NAME))).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.DOUBLE)).build();
        this.start(MySqlConnector.class, this.config);
        this.assertDoubleChangeRecord(this.consumeInsert());
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-730", "DBZ-4730"})
    public void testStringDecimalHandlingMode() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName(TABLE_NAME))).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING)).build();
        this.start(MySqlConnector.class, this.config);
        this.assertStringChangeRecord(this.consumeInsert());
        this.stopConnector();
    }

    private SourceRecord consumeInsert() throws InterruptedException {
        int numDatabase = 2;
        int numTables = 4;
        boolean numOthers = true;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        Assertions.assertThat((Object)records).isNotNull();
        List events = records.recordsForTopic(this.DATABASE.topicForTable(TABLE_NAME));
        Assertions.assertThat((List)events).hasSize(1);
        return (SourceRecord)events.get(0);
    }

    private void assertBigDecimalChangeRecord(SourceRecord record) {
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Object)change.get("A")).isEqualTo((Object)new BigDecimal("1.33"));
        Assertions.assertThat((Object)change.get("B")).isEqualTo((Object)new BigDecimal("-2.111"));
        Assertions.assertThat((Object)change.get("C")).isEqualTo((Object)new BigDecimal("3.44400"));
        Assertions.assertThat((Object)change.getWithoutDefault("D")).isNull();
        Assertions.assertThat((Object)change.get("E")).isEqualTo((Object)new BigDecimal("0.000000000000000000"));
        Assertions.assertThat((Object)record.valueSchema().field("after").schema().field("D").schema().defaultValue()).isEqualTo((Object)new BigDecimal("15.28000"));
    }

    private void assertDoubleChangeRecord(SourceRecord record) {
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Double)change.getFloat64("A")).isEqualTo(1.33);
        Assertions.assertThat((Double)change.getFloat64("B")).isEqualTo(-2.111);
        Assertions.assertThat((Double)change.getFloat64("C")).isEqualTo(3.444);
        Assertions.assertThat((Double)change.getFloat64("D")).isNull();
        Assertions.assertThat((Double)change.getFloat64("E")).isEqualTo(0.0);
        Assertions.assertThat((Object)record.valueSchema().field("after").schema().field("D").schema().defaultValue()).isEqualTo((Object)15.28);
    }

    private void assertStringChangeRecord(SourceRecord record) {
        Assertions.assertThat((Object)record).isNotNull();
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((String)change.getString("A").trim()).isEqualTo((Object)"1.33");
        Assertions.assertThat((String)change.getString("B").trim()).isEqualTo((Object)"-2.111");
        Assertions.assertThat((String)change.getString("C").trim()).isEqualTo((Object)"3.44400");
        Assertions.assertThat((String)change.getString("D")).isNull();
        Assertions.assertThat((String)change.getString("E")).isEqualTo((Object)"0.000000000000000000");
        Assertions.assertThat((Object)record.valueSchema().field("after").schema().field("D").schema().defaultValue()).isEqualTo((Object)"15.28000");
    }
}

