/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.GtidSet;
import io.debezium.util.Collect;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class GtidSetTest {
    private static final String UUID1 = "24bc7850-2c16-11e6-a073-0242ac110002";
    private GtidSet gtids;

    @Test
    public void shouldCreateSetWithSingleInterval() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191");
        this.asertIntervalCount(UUID1, 1);
        this.asertIntervalExists(UUID1, 1, 191);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertLastInterval(UUID1, 1, 191);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191");
    }

    @Test
    public void shouldCollapseAdjacentIntervals() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:192-199");
        this.asertIntervalCount(UUID1, 1);
        this.asertIntervalExists(UUID1, 1, 199);
        this.asertFirstInterval(UUID1, 1, 199);
        this.asertLastInterval(UUID1, 1, 199);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-199");
    }

    @Test
    public void shouldNotCollapseNonAdjacentIntervals() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199");
        this.asertIntervalCount(UUID1, 2);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertLastInterval(UUID1, 193, 199);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199");
    }

    @Test
    public void shouldCreateWithMultipleIntervals() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199:1000-1033");
        this.asertIntervalCount(UUID1, 3);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertIntervalExists(UUID1, 193, 199);
        this.asertLastInterval(UUID1, 1000, 1033);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199:1000-1033");
    }

    @Test
    public void shouldCreateWithMultipleIntervalsThatMayBeAdjacent() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:192-199:1000-1033:1035-1036:1038-1039");
        this.asertIntervalCount(UUID1, 4);
        this.asertFirstInterval(UUID1, 1, 199);
        this.asertIntervalExists(UUID1, 1000, 1033);
        this.asertIntervalExists(UUID1, 1035, 1036);
        this.asertLastInterval(UUID1, 1038, 1039);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-199:1000-1033:1035-1036:1038-1039");
    }

    @Test
    public void shouldCorrectlyDetermineIfSimpleGtidSetIsContainedWithinAnother() {
        this.gtids = new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41"))).isTrue();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-42"))).isTrue();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:2-41"))).isFalse();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7145bf69-d1ca-11e5-a588-0242ac110004:1"))).isFalse();
    }

    @Test
    public void shouldCorrectlyDetermineIfComplexGtidSetIsContainedWithinAnother() {
        GtidSet connector = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        GtidSet server = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3202,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Assertions.assertThat((boolean)connector.isContainedWithin(server)).isTrue();
    }

    @Test
    public void shouldCorrectlyDetermineIfComplexGtidSetWithVariousLineSeparatorsIsContainedWithinAnother() {
        GtidSet connector = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Arrays.stream(new String[]{"\r\n", "\n", "\r"}).forEach(separator -> {
            GtidSet server = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2," + separator + "7145bf69-d1ca-11e5-a588-0242ac110004:1-3202," + separator + "7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
            Assertions.assertThat((boolean)connector.isContainedWithin(server)).isTrue();
        });
    }

    @Test
    public void shouldFilterServerUuids() {
        String gtidStr = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41";
        List keepers = Collect.arrayListOf((Object)"036d85a9-64e5-11e6-9b48-42010af0000c", (Object[])new String[]{"7c1de3f2-3fd2-11e6-9cdc-42010af000bc", "wont-be-found"});
        GtidSet original = new GtidSet(gtidStr);
        Assertions.assertThat((Object)original.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNotNull();
        GtidSet filtered = original.retainAll(keepers::contains);
        List actualUuids = filtered.getUUIDSets().stream().map(GtidSet.UUIDSet::getUUID).collect(Collectors.toList());
        Assertions.assertThat((boolean)keepers.containsAll(actualUuids)).isTrue();
        Assertions.assertThat((Object)filtered.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNull();
    }

    @Test
    public void subtract() {
        String gtidStr1 = "036d85a9-64e5-11e6-9b48-42010af0000c:1-20,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200:3400-3800:3900-3990,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:5-8:12-18:25-55:60-65";
        String gtidStr2 = "036d85a9-64e5-11e6-9b48-42010af0000c:1-21,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200:3400-3800:4500,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-49:62-70:80-100";
        String diff = "036d85a9-64e5-11e6-9b48-42010af0000c:21,7145bf69-d1ca-11e5-a588-0242ac110004:4500,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-4:9-11:19-24:66-70:80-100";
        GtidSet gtidSet1 = new GtidSet(gtidStr1);
        GtidSet gtidSet2 = new GtidSet(gtidStr2);
        GtidSet gtidSetDiff = gtidSet2.subtract(gtidSet1);
        GtidSet expectedDiff = new GtidSet(diff);
        Assertions.assertThat((Object)gtidSetDiff).isEqualTo((Object)expectedDiff);
    }

    @Test
    public void removeInterval() {
        GtidSet.Interval interval1 = new GtidSet.Interval(3L, 7L);
        GtidSet.Interval interval2 = new GtidSet.Interval(2L, 5L);
        GtidSet.Interval interval3 = new GtidSet.Interval(4L, 5L);
        GtidSet.Interval interval4 = new GtidSet.Interval(9L, 12L);
        GtidSet.Interval interval5 = new GtidSet.Interval(0L, 2L);
        Assertions.assertThat((List)interval1.remove(interval2)).isEqualTo(Collections.singletonList(new GtidSet.Interval(6L, 7L)));
        Assertions.assertThat((List)interval2.remove(interval1)).isEqualTo(Collections.singletonList(new GtidSet.Interval(2L, 2L)));
        Assertions.assertThat((List)interval1.remove(interval3)).isEqualTo(Arrays.asList(new GtidSet.Interval(3L, 3L), new GtidSet.Interval(6L, 7L)));
        Assertions.assertThat((List)interval1.remove(interval4)).isEqualTo(Collections.singletonList(interval1));
        Assertions.assertThat((List)interval1.remove(interval5)).isEqualTo(Collections.singletonList(interval1));
        Assertions.assertThat((List)interval3.remove(interval1)).isEqualTo(Collections.emptyList());
        Assertions.assertThat((List)interval3.remove(interval3)).isEqualTo(Collections.emptyList());
    }

    @Test
    public void removeAllIntervals() {
        GtidSet.Interval interval = new GtidSet.Interval(1L, 49L);
        List<GtidSet.Interval> intervalsToRemove = Arrays.asList(new GtidSet.Interval(5L, 8L), new GtidSet.Interval(12L, 18L), new GtidSet.Interval(25L, 55L), new GtidSet.Interval(60L, 65L));
        List<GtidSet.Interval> diff = Arrays.asList(new GtidSet.Interval(1L, 4L), new GtidSet.Interval(9L, 11L), new GtidSet.Interval(19L, 24L));
        Assertions.assertThat((List)interval.removeAll(intervalsToRemove)).isEqualTo(diff);
    }

    protected void asertIntervalCount(String uuid, int count) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        Assertions.assertThat((int)set.getIntervals().size()).isEqualTo(count);
    }

    protected void asertIntervalExists(String uuid, int start, int end) {
        Assertions.assertThat((boolean)this.hasInterval(uuid, start, end)).isTrue();
    }

    protected void asertFirstInterval(String uuid, int start, int end) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        GtidSet.Interval interval = (GtidSet.Interval)set.getIntervals().iterator().next();
        Assertions.assertThat((long)interval.getStart()).isEqualTo((long)start);
        Assertions.assertThat((long)interval.getEnd()).isEqualTo((long)end);
    }

    protected void asertLastInterval(String uuid, int start, int end) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        GtidSet.Interval interval = (GtidSet.Interval)new LinkedList(set.getIntervals()).getLast();
        Assertions.assertThat((long)interval.getStart()).isEqualTo((long)start);
        Assertions.assertThat((long)interval.getEnd()).isEqualTo((long)end);
    }

    protected boolean hasInterval(String uuid, int start, int end) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        for (GtidSet.Interval interval : set.getIntervals()) {
            if (interval.getStart() != (long)start || interval.getEnd() != (long)end) continue;
            return true;
        }
        return false;
    }
}

