/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.storage.file.history.FileDatabaseHistory;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public class UniqueDatabase {
    public static final ZoneId TIMEZONE = ZoneId.of("US/Samoa");
    private static final String DEFAULT_DATABASE = "mysql";
    private static final String[] CREATE_DATABASE_DDL = new String[]{"CREATE DATABASE `$DBNAME$`;", "USE `$DBNAME$`;"};
    private static final String[] CREATE_DATABASE_WITH_CHARSET_DDL = new String[]{"CREATE DATABASE `$DBNAME$` CHARSET $CHARSET$;", "USE `$DBNAME$`;"};
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(.*)--.*$");
    private final String databaseName;
    private final String charset;
    private final String templateName;
    private final String serverName;
    private Path dbHistoryPath;
    private final String identifier;

    public UniqueDatabase(String serverName, String databaseName, String identifier, String charset) {
        this.identifier = identifier;
        this.databaseName = identifier != null ? databaseName + "_" + identifier : databaseName;
        this.templateName = databaseName;
        this.serverName = serverName;
        this.charset = charset;
    }

    public UniqueDatabase(String serverName, String databaseName) {
        this(serverName, databaseName, Integer.toUnsignedString(new Random().nextInt(), 36), null);
    }

    public UniqueDatabase(String serverName, String databaseName, String charset) {
        this(serverName, databaseName, Integer.toUnsignedString(new Random().nextInt(), 36), charset);
    }

    public UniqueDatabase(String serverName, String databaseName, UniqueDatabase sibling) {
        this(serverName, databaseName, sibling.getIdentifier(), null);
    }

    private String convertSQL(String sql) {
        String dbReplace = sql.replace("$DBNAME$", this.databaseName);
        return this.charset != null ? dbReplace.replace("$CHARSET$", this.charset) : dbReplace;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String topicForTable(String tableName) {
        return String.format("%s.%s.%s", this.serverName, this.databaseName, tableName);
    }

    public String qualifiedTableName(String tableName) {
        return String.format("%s.%s", this.databaseName, tableName);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void createAndInitialize() {
        this.createAndInitialize(Collections.emptyMap());
    }

    public void createAndInitialize(Map<String, Object> urlProperties) {
        String ddlFile = String.format("ddl/%s.sql", this.templateName);
        URL ddlTestFile = UniqueDatabase.class.getClassLoader().getResource(ddlFile);
        Assert.assertNotNull((String)("Cannot locate " + ddlFile), (Object)ddlTestFile);
        try (MySqlTestConnection connection = MySqlTestConnection.forTestDatabase(DEFAULT_DATABASE, urlProperties);){
            List<String> statements = Arrays.stream(Stream.concat(Arrays.stream(this.charset != null ? CREATE_DATABASE_WITH_CHARSET_DDL : CREATE_DATABASE_DDL), Files.readAllLines(Paths.get(ddlTestFile.toURI())).stream()).map(String::trim).filter(x -> !x.startsWith("--") && !x.isEmpty()).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).map(this::convertSQL).collect(Collectors.joining("\n")).split(";")).map(x -> x.replace("$$", ";")).collect(Collectors.toList());
            connection.execute(statements.toArray(new String[statements.size()]));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public UniqueDatabase withDbHistoryPath(Path dbHistoryPath) {
        this.dbHistoryPath = dbHistoryPath;
        return this;
    }

    public Configuration.Builder defaultJdbcConfigBuilder() {
        Configuration.Builder builder = (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname", "localhost"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.port", "3306"))).with(MySqlConnectorConfig.USER, "snapper")).with(MySqlConnectorConfig.PASSWORD, "snapperpass");
        String sslMode = System.getProperty("database.ssl.mode", "disabled");
        if (sslMode.equals("disabled")) {
            builder.with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED);
        } else {
            URL trustStoreFile = UniqueDatabase.class.getClassLoader().getResource("ssl/truststore");
            URL keyStoreFile = UniqueDatabase.class.getClassLoader().getResource("ssl/keystore");
            ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(MySqlConnectorConfig.SSL_MODE, sslMode)).with(MySqlConnectorConfig.SSL_TRUSTSTORE, System.getProperty("database.ssl.truststore", trustStoreFile.getPath()))).with(MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD, System.getProperty("database.ssl.truststore.password", "debezium"))).with(MySqlConnectorConfig.SSL_KEYSTORE, System.getProperty("database.ssl.keystore", keyStoreFile.getPath()))).with(MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD, System.getProperty("database.ssl.keystore.password", "debezium"));
        }
        if (this.dbHistoryPath != null) {
            builder.with(FileDatabaseHistory.FILE_PATH, (Object)this.dbHistoryPath);
        }
        return builder;
    }

    public Configuration.Builder defaultConfig() {
        return (Configuration.Builder)this.defaultConfigWithoutDatabaseFilter().with(MySqlConnectorConfig.DATABASE_INCLUDE_LIST, this.getDatabaseName());
    }

    public Configuration.Builder defaultConfigWithoutDatabaseFilter() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.defaultJdbcConfigBuilder().with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.SERVER_NAME, this.getServerName())).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(MySqlConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER, 10000);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ZoneId timezone() {
        return TIMEZONE;
    }
}

