/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.signal;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.MySqlReadOnlyIncrementalSnapshotChangeEventSource;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.pipeline.signal.AbstractSnapshotSignal;
import io.debezium.pipeline.signal.ExecuteSnapshot;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import io.debezium.util.Threads;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSignalThread<T extends DataCollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSignalThread.class);
    private final ExecutorService signalTopicListenerExecutor;
    private final String topicName;
    private final String connectorName;
    private final Duration pollTimeoutMs;
    private final MySqlReadOnlyIncrementalSnapshotChangeEventSource<T> eventSource;
    private final KafkaConsumer<String, String> signalsConsumer;
    public static final String CONFIGURATION_FIELD_PREFIX_STRING = "signal.";
    private static final String CONSUMER_PREFIX = "signal.consumer.";
    public static final Field SIGNAL_TOPIC = Field.create((String)"signal.kafka.topic").withDisplayName("Signal topic name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDescription("The name of the topic for the signals to the connector").withValidation(new Field.Validator[]{Field::isRequired});
    public static final Field BOOTSTRAP_SERVERS = Field.create((String)"signal.kafka.bootstrap.servers").withDisplayName("Kafka broker addresses").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDescription("A list of host/port pairs that the connector will use for establishing the initial connection to the Kafka cluster for retrieving signals to the connector.This should point to the same Kafka cluster used by the Kafka Connect process.").withValidation(new Field.Validator[]{Field::isRequired});
    public static final Field SIGNAL_POLL_TIMEOUT_MS = Field.create((String)"signal.signal.kafka.poll.timeout.ms").withDisplayName("Poll timeout for kafka signals (ms)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The number of milliseconds to wait while polling signals.").withDefault(100).withValidation(new Field.Validator[]{Field::isNonNegativeInteger});

    public KafkaSignalThread(Class<? extends SourceConnector> connectorType, CommonConnectorConfig connectorConfig, MySqlReadOnlyIncrementalSnapshotChangeEventSource<T> eventSource) {
        String signalName = "kafka-signal";
        this.connectorName = connectorConfig.getLogicalName();
        this.signalTopicListenerExecutor = Threads.newSingleThreadExecutor(connectorType, (String)this.connectorName, (String)signalName, (boolean)true);
        Configuration signalConfig = ((Configuration.Builder)connectorConfig.getConfig().subset(CONFIGURATION_FIELD_PREFIX_STRING, false).edit().withDefault(SIGNAL_TOPIC, this.connectorName + "-signal")).build();
        this.eventSource = eventSource;
        this.topicName = signalConfig.getString(SIGNAL_TOPIC);
        this.pollTimeoutMs = Duration.ofMillis(signalConfig.getInteger(SIGNAL_POLL_TIMEOUT_MS));
        String bootstrapServers = signalConfig.getString(BOOTSTRAP_SERVERS);
        Configuration consumerConfig = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)signalConfig.subset(CONSUMER_PREFIX, true).edit().withDefault("bootstrap.servers", bootstrapServers).withDefault("client.id", UUID.randomUUID().toString()).withDefault("group.id", signalName).withDefault("fetch.min.bytes", 1)).withDefault("enable.auto.commit", false)).withDefault("session.timeout.ms", 10000)).withDefault("key.deserializer", StringDeserializer.class)).withDefault("value.deserializer", StringDeserializer.class)).build();
        this.signalsConsumer = new KafkaConsumer(consumerConfig.asProperties());
        LOGGER.info("Subscribing to signals topic '{}'", (Object)this.topicName);
        this.signalsConsumer.assign((Collection)Collect.arrayListOf((Object)new TopicPartition(this.topicName, 0), (Object[])new TopicPartition[0]));
    }

    public void start() {
        this.signalTopicListenerExecutor.submit(this::monitorSignals);
    }

    private void monitorSignals() {
        block3: while (true) {
            ConsumerRecords recoveredRecords = this.signalsConsumer.poll(this.pollTimeoutMs.toMillis());
            Iterator iterator = recoveredRecords.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block3;
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                try {
                    this.processSignal((ConsumerRecord<String, String>)record);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("Signals processing was interrupted", (Throwable)e);
                    this.signalsConsumer.close();
                    return;
                }
                catch (Exception e) {
                    LOGGER.error("Skipped signal due to an error '{}'", (Object)record, (Object)e);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private void processSignal(ConsumerRecord<String, String> record) throws IOException, InterruptedException {
        if (!this.connectorName.equals(record.key())) {
            LOGGER.info("Signal key '{}' doesn't match the connector's name '{}'", record.key(), (Object)this.connectorName);
            return;
        }
        String value = (String)record.value();
        LOGGER.trace("Processing signal: {}", (Object)value);
        Document jsonData = value == null || value.isEmpty() ? Document.create() : DocumentReader.defaultReader().read(value);
        String type = jsonData.getString((CharSequence)"type");
        Document data = jsonData.getDocument((CharSequence)"data");
        if ("execute-snapshot".equals(type)) {
            this.executeSnapshot(data, record.offset());
        } else {
            LOGGER.warn("Unknown signal type {}", (Object)type);
        }
    }

    private void executeSnapshot(Document data, long signalOffset) {
        List dataCollections = ExecuteSnapshot.getDataCollections((Document)data);
        if (dataCollections != null) {
            AbstractSnapshotSignal.SnapshotType snapshotType = ExecuteSnapshot.getSnapshotType((Document)data);
            LOGGER.info("Requested '{}' snapshot of data collections '{}'", (Object)snapshotType, (Object)dataCollections);
            if (snapshotType == AbstractSnapshotSignal.SnapshotType.INCREMENTAL) {
                this.eventSource.enqueueDataCollectionNamesToSnapshot(dataCollections, signalOffset);
            }
        }
    }

    public void seek(long signalOffset) {
        this.signalsConsumer.seek(new TopicPartition(this.topicName, 0), signalOffset + 1L);
    }
}

