/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.history.AbstractDatabaseHistory;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.text.ParsingException;
import io.debezium.util.IoUtil;
import io.debezium.util.SchemaNameAdjuster;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlDatabaseSchemaTest {
    private static final Path TEST_FILE_PATH = Testing.Files.createTestingPath((String)"dbHistory.log");
    private final UniqueDatabase DATABASE = new UniqueDatabase("testServer", "connector_test", null, null).withDbHistoryPath(TEST_FILE_PATH);
    private static final String SERVER_NAME = "testServer";
    private MySqlDatabaseSchema mysql;
    private MySqlConnectorConfig connectorConfig;

    @Before
    public void beforeEach() {
        Testing.Files.delete((Path)TEST_FILE_PATH);
    }

    private MySqlDatabaseSchema getSchema(Configuration config) {
        config = ((Configuration.Builder)config.edit().with(AbstractDatabaseHistory.INTERNAL_PREFER_DDL, true)).build();
        this.connectorConfig = new MySqlConnectorConfig(config);
        MySqlValueConverters mySqlValueConverters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.ADAPTIVE, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, MySqlValueConverters::adjustTemporal, MySqlValueConverters::defaultParsingErrorHandler);
        return new MySqlDatabaseSchema(this.connectorConfig, mySqlValueConverters, MySqlTopicSelector.defaultSelector((MySqlConnectorConfig)this.connectorConfig), SchemaNameAdjuster.create(), false);
    }

    @After
    public void afterEach() {
        if (this.mysql != null) {
            try {
                this.mysql.close();
            }
            finally {
                this.mysql = null;
            }
        }
    }

    @Test
    public void shouldApplyDdlStatementsAndRecover() throws InterruptedException {
        Configuration config = this.DATABASE.defaultConfig().build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    public void shouldIgnoreUnparseableDdlAndRecover() throws InterruptedException {
        Configuration config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, true)).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.parseStreamingDdl(partition, "xxxCREATE TABLE mytable\n" + IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailOnUnparseableDdl() throws InterruptedException {
        Configuration config = this.DATABASE.defaultConfig().build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.parseStreamingDdl(partition, "xxxCREATE TABLE mytable\n" + IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
    }

    @Test
    public void shouldLoadSystemAndNonSystemTablesAndConsumeOnlyFilteredDatabases() throws InterruptedException {
        Configuration config = ((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, true)).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-test-init-5.7.ddl"), "mysql", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        offset.setBinlogStartPoint("binlog.001", 1000L);
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertTableExcluded("mysql.columns_priv");
        this.assertNoTablesExistForDatabase("mysql");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    public void shouldLoadSystemAndNonSystemTablesAndConsumeAllDatabases() throws InterruptedException {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, true)).with(MySqlConnectorConfig.TABLE_IGNORE_BUILTIN, false)).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, "SET character_set_server=utf8mb4", null, offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-test-init-5.7.ddl"), "mysql", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        offset.setBinlogStartPoint("binlog.001", 1000L);
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-products.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertTableIncluded("mysql.columns_priv");
        this.assertTablesExistForDatabase("mysql");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    public void shouldAllowDecimalPrecision() {
        Configuration config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-decimal-issue.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("connector_test.business_order");
        this.assertTableIncluded("connector_test.business_order_detail");
        this.assertHistoryRecorded(config, partition, (OffsetContext)offset);
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldStoreNonCapturedDatabase() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(MySqlConnectorConfig.DATABASE_INCLUDE_LIST, "captured")).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.mysql = this.getSchema(configFull);
        this.mysql.recover(Offsets.of((Partition)partition, (OffsetContext)offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableIncluded("non_captured.nct");
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldNotStoreNonCapturedDatabase() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(MySqlConnectorConfig.DATABASE_INCLUDE_LIST, "captured")).with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.mysql = this.getSchema(configFull);
        this.mysql.recover(Offsets.of((Partition)partition, (OffsetContext)offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldStoreNonCapturedTable() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, "captured.ct")).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableExcluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.mysql = this.getSchema(configFull);
        this.mysql.recover(Offsets.of((Partition)partition, (OffsetContext)offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableIncluded("captured.nct");
        this.assertTableIncluded("non_captured.nct");
    }

    @Test
    @FixFor(value={"DBZ-3622"})
    public void shouldNotStoreNonCapturedTable() {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfigWithoutDatabaseFilter().with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, false)).with(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, "captured.ct")).build();
        this.mysql = this.getSchema(config);
        this.mysql.initializeStorage();
        MySqlPartition partition = this.initializePartition(this.connectorConfig, config);
        MySqlOffsetContext offset = this.initializeOffset(this.connectorConfig);
        offset.setBinlogStartPoint("binlog.001", 400L);
        this.mysql.parseStreamingDdl(partition, IoUtil.readClassPathResource((String)"ddl/mysql-schema-captured.ddl"), "db1", offset, Instant.now()).forEach(x -> this.mysql.applySchemaChange(x));
        this.mysql.close();
        this.assertTableIncluded("captured.ct");
        this.assertTableExcluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
        Configuration configFull = this.DATABASE.defaultConfigWithoutDatabaseFilter().build();
        this.mysql = this.getSchema(configFull);
        this.mysql.recover(Offsets.of((Partition)partition, (OffsetContext)offset));
        this.assertTableIncluded("captured.ct");
        this.assertTableExcluded("captured.nct");
        this.assertTableExcluded("non_captured.nct");
    }

    protected void assertTableIncluded(String fullyQualifiedTableName) {
        TableId tableId = TableId.parse((String)fullyQualifiedTableName);
        TableSchema tableSchema = this.mysql.schemaFor(tableId);
        Assertions.assertThat((Object)tableSchema).isNotNull();
        Assertions.assertThat((String)tableSchema.keySchema().name()).isEqualTo((Object)SchemaNameAdjuster.validFullname((String)("testServer." + fullyQualifiedTableName + ".Key")));
        Assertions.assertThat((String)tableSchema.valueSchema().name()).isEqualTo((Object)SchemaNameAdjuster.validFullname((String)("testServer." + fullyQualifiedTableName + ".Value")));
    }

    protected void assertTableExcluded(String fullyQualifiedTableName) {
        TableId tableId = TableId.parse((String)fullyQualifiedTableName);
        Assertions.assertThat((Object)this.mysql.schemaFor(tableId)).isNull();
    }

    protected void assertNoTablesExistForDatabase(String dbName) {
        Assertions.assertThat((long)this.mysql.tableIds().stream().filter(id -> id.catalog().equals(dbName)).count()).isEqualTo(0L);
    }

    protected void assertTablesExistForDatabase(String dbName) {
        Assertions.assertThat((long)this.mysql.tableIds().stream().filter(id -> id.catalog().equals(dbName)).count()).isGreaterThan(0L);
    }

    protected void assertHistoryRecorded(Configuration config, MySqlPartition partition, OffsetContext offset) {
        try (MySqlDatabaseSchema duplicate = this.getSchema(config);){
            duplicate.recover(Offsets.of((Partition)partition, (OffsetContext)offset));
            Assertions.assertThat((Collection)duplicate.tableIds()).isEqualTo((Object)this.mysql.tableIds());
            for (int i = 0; i != 2; ++i) {
                duplicate.tableIds().forEach(tableId -> {
                    TableSchema dupSchema = duplicate.schemaFor(tableId);
                    TableSchema schema = this.mysql.schemaFor(tableId);
                    Assertions.assertThat((Object)schema).isEqualTo((Object)dupSchema);
                    Table dupTable = duplicate.tableFor(tableId);
                    Table table = this.mysql.tableFor(tableId);
                    Assertions.assertThat((Object)table).isEqualTo((Object)dupTable);
                });
                this.mysql.tableIds().forEach(tableId -> {
                    TableSchema dupSchema = duplicate.schemaFor(tableId);
                    TableSchema schema = this.mysql.schemaFor(tableId);
                    Assertions.assertThat((Object)schema).isEqualTo((Object)dupSchema);
                    Table dupTable = duplicate.tableFor(tableId);
                    Table table = this.mysql.tableFor(tableId);
                    Assertions.assertThat((Object)table).isEqualTo((Object)dupTable);
                });
                duplicate.refreshSchemas();
            }
        }
    }

    protected void printStatements(String dbName, Set<TableId> tables, String ddlStatements) {
        Testing.print((Object)("Running DDL for '" + dbName + "': " + ddlStatements + " changing tables '" + tables + "'"));
    }

    private MySqlPartition initializePartition(MySqlConnectorConfig connectorConfig, Configuration taskConfig) {
        Set partitions = new MySqlPartition.Provider(connectorConfig, taskConfig).getPartitions();
        Assertions.assertThat((int)partitions.size()).isEqualTo(1);
        return (MySqlPartition)partitions.iterator().next();
    }

    private MySqlOffsetContext initializeOffset(MySqlConnectorConfig connectorConfig) {
        return MySqlOffsetContext.initial((MySqlConnectorConfig)connectorConfig);
    }
}

