/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlNumericColumnIT
extends AbstractConnectorTest {
    private static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-numeric-column.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("numericcolumnit", "numeric_column_test").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-751"})
    public void shouldSetPrecisionSchemaParameter() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_751_numeric_column_test"));
        Assertions.assertThat((List)dmls).hasSize(1);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Map rating1SchemaParameters = insert.valueSchema().field("before").schema().field("rating1").schema().parameters();
        Assertions.assertThat((Map)rating1SchemaParameters).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"scale", (Object)"0"), MapAssert.entry((Object)PRECISION_PARAMETER_KEY, (Object)"10")});
        Map rating2SchemaParameters = insert.valueSchema().field("before").schema().field("rating2").schema().parameters();
        Assertions.assertThat((Map)rating2SchemaParameters).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"scale", (Object)"4"), MapAssert.entry((Object)PRECISION_PARAMETER_KEY, (Object)"8")});
        Map rating3SchemaParameters = insert.valueSchema().field("before").schema().field("rating3").schema().parameters();
        Assertions.assertThat((Map)rating3SchemaParameters).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"scale", (Object)"0"), MapAssert.entry((Object)PRECISION_PARAMETER_KEY, (Object)"7")});
        Map rating4SchemaParameters = insert.valueSchema().field("before").schema().field("rating4").schema().parameters();
        Assertions.assertThat((Map)rating4SchemaParameters).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"scale", (Object)"0"), MapAssert.entry((Object)PRECISION_PARAMETER_KEY, (Object)"6")});
    }
}

