/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.junit;

import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.junit.DatabaseVersionResolver;

public class MySqlDatabaseVersionResolver
implements DatabaseVersionResolver {
    public DatabaseVersionResolver.DatabaseVersion getVersion() {
        String versionString = MySqlTestConnection.forTestDatabase("mysql").getMySqlVersionString();
        String[] tokens = versionString.split("\\.");
        if (tokens.length == 0) {
            throw new IllegalStateException("Failed to resolve database version");
        }
        int major = MySqlDatabaseVersionResolver.sanitizeAndParseToken(tokens[0]);
        int minor = tokens.length >= 2 ? MySqlDatabaseVersionResolver.sanitizeAndParseToken(tokens[1]) : 0;
        int patch = tokens.length >= 3 ? MySqlDatabaseVersionResolver.sanitizeAndParseToken(tokens[2]) : 0;
        return new DatabaseVersionResolver.DatabaseVersion(major, minor, patch);
    }

    private static int sanitizeAndParseToken(String token) {
        String[] tokens = token.split("[^0-9]+");
        if (tokens.length == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(tokens[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

