/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.data.Envelope;
import io.debezium.metrics.Metrics;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.meters.CommonEventMeter;
import io.debezium.pipeline.metrics.ChangeEventSourceMetricsMXBean;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionId;
import org.apache.kafka.connect.data.Struct;

@ThreadSafe
public abstract class PipelineMetrics<P extends Partition>
extends Metrics
implements DataChangeEventListener<P>,
ChangeEventSourceMetricsMXBean {
    protected final EventMetadataProvider metadataProvider;
    private final ChangeEventQueueMetrics changeEventQueueMetrics;
    protected final CdcSourceTaskContext taskContext;
    private final CommonEventMeter commonEventMeter;

    protected <T extends CdcSourceTaskContext> PipelineMetrics(T taskContext, String contextName, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        super(taskContext, contextName);
        this.taskContext = taskContext;
        this.changeEventQueueMetrics = changeEventQueueMetrics;
        this.metadataProvider = metadataProvider;
        this.commonEventMeter = new CommonEventMeter(taskContext.getClock(), metadataProvider);
    }

    @Override
    public void onEvent(P partition, DataCollectionId source, OffsetContext offset, Object key, Struct value, Envelope.Operation operation) {
        this.commonEventMeter.onEvent(source, offset, key, value, operation);
    }

    @Override
    public void onFilteredEvent(P partition, String event) {
        this.commonEventMeter.onFilteredEvent();
    }

    @Override
    public void onFilteredEvent(P partition, String event, Envelope.Operation operation) {
        this.commonEventMeter.onFilteredEvent(operation);
    }

    @Override
    public void onErroneousEvent(P partition, String event) {
        this.commonEventMeter.onErroneousEvent();
    }

    @Override
    public void onErroneousEvent(P partition, String event, Envelope.Operation operation) {
        this.commonEventMeter.onErroneousEvent(operation);
    }

    @Override
    public void onConnectorEvent(P partition, ConnectorEvent event) {
    }

    @Override
    public String getLastEvent() {
        return this.commonEventMeter.getLastEvent();
    }

    @Override
    public long getMilliSecondsSinceLastEvent() {
        return this.commonEventMeter.getMilliSecondsSinceLastEvent();
    }

    @Override
    public long getTotalNumberOfEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfEventsSeen();
    }

    @Override
    public long getTotalNumberOfCreateEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfCreateEventsSeen();
    }

    @Override
    public long getTotalNumberOfUpdateEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfUpdateEventsSeen();
    }

    @Override
    public long getTotalNumberOfDeleteEventsSeen() {
        return this.commonEventMeter.getTotalNumberOfDeleteEventsSeen();
    }

    @Override
    public long getNumberOfEventsFiltered() {
        return this.commonEventMeter.getNumberOfEventsFiltered();
    }

    @Override
    public long getNumberOfErroneousEvents() {
        return this.commonEventMeter.getNumberOfErroneousEvents();
    }

    @Override
    public void reset() {
        this.commonEventMeter.reset();
    }

    @Override
    public int getQueueTotalCapacity() {
        return this.changeEventQueueMetrics.totalCapacity();
    }

    @Override
    public int getQueueRemainingCapacity() {
        return this.changeEventQueueMetrics.remainingCapacity();
    }

    @Override
    public long getMaxQueueSizeInBytes() {
        return this.changeEventQueueMetrics.maxQueueSizeInBytes();
    }

    @Override
    public long getCurrentQueueSizeInBytes() {
        return this.changeEventQueueMetrics.currentQueueSizeInBytes();
    }
}

