/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.util.Collect;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private final ObjectName name;
    private volatile boolean registered = false;

    protected Metrics(CdcSourceTaskContext taskContext, String contextName) {
        this.name = this.metricName(taskContext.getConnectorType(), taskContext.getConnectorName(), contextName);
    }

    protected Metrics(CdcSourceTaskContext taskContext, Map<String, String> tags) {
        this.name = this.metricName(taskContext.getConnectorType(), tags);
    }

    protected Metrics(CommonConnectorConfig connectorConfig, String contextName, boolean multiPartitionMode) {
        String connectorType = connectorConfig.getContextName();
        String connectorName = connectorConfig.getLogicalName();
        this.name = multiPartitionMode ? this.metricName(connectorType, Collect.linkMapOf("server", connectorName, "task", connectorConfig.getTaskId(), "context", contextName)) : this.metricName(connectorType, connectorName, contextName);
    }

    public synchronized void register() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (mBeanServer == null) {
                LOGGER.info("JMX not supported, bean '{}' not registered", (Object)this.name);
                return;
            }
            mBeanServer.registerMBean(this, this.name);
            this.registered = true;
        }
        catch (JMException e) {
            throw new RuntimeException("Unable to register the MBean '" + this.name + "'", e);
        }
    }

    public synchronized void unregister() {
        if (this.name != null && this.registered) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mBeanServer == null) {
                    LOGGER.debug("JMX not supported, bean '{}' not registered", (Object)this.name);
                    return;
                }
                mBeanServer.unregisterMBean(this.name);
                this.registered = false;
            }
            catch (JMException e) {
                throw new RuntimeException("Unable to unregister the MBean '" + this.name + "'", e);
            }
        }
    }

    protected ObjectName metricName(String connectorType, String connectorName, String contextName) {
        return this.metricName(connectorType, Collect.linkMapOf("context", contextName, "server", connectorName));
    }

    protected ObjectName metricName(String connectorType, Map<String, String> tags) {
        String metricName = "debezium." + connectorType.toLowerCase() + ":type=connector-metrics," + tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + Sanitizer.jmxSanitize((String)((String)e.getValue()))).collect(Collectors.joining(","));
        try {
            return new ObjectName(metricName);
        }
        catch (MalformedObjectNameException e2) {
            throw new ConnectException("Invalid metric name '" + metricName + "'");
        }
    }
}

