/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlSnapshotChangeEventSourceMetricsMXBean;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.pipeline.metrics.DefaultSnapshotChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import java.util.concurrent.atomic.AtomicBoolean;

class MySqlSnapshotChangeEventSourceMetrics
extends DefaultSnapshotChangeEventSourceMetrics
implements MySqlSnapshotChangeEventSourceMetricsMXBean {
    private final AtomicBoolean holdingGlobalLock = new AtomicBoolean();
    private final MySqlDatabaseSchema schema;

    public MySqlSnapshotChangeEventSourceMetrics(MySqlTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider eventMetadataProvider) {
        super((CdcSourceTaskContext)taskContext, changeEventQueueMetrics, eventMetadataProvider);
        this.schema = taskContext.getSchema();
    }

    @Override
    public boolean getHoldingGlobalLock() {
        return this.holdingGlobalLock.get();
    }

    public void globalLockAcquired() {
        this.holdingGlobalLock.set(true);
    }

    public void globalLockReleased() {
        this.holdingGlobalLock.set(false);
    }

    public String[] getMonitoredTables() {
        return this.schema.capturedTablesAsStringArray();
    }

    public String[] getCapturedTables() {
        return this.schema.capturedTablesAsStringArray();
    }

    public long getTotalNumberOfEventsSeen() {
        return this.getRowsScanned().values().stream().mapToLong(x -> x).sum();
    }
}

