/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MysqlFieldReader;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.util.Collect;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMysqlFieldReader
implements MysqlFieldReader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Set<String> TEXT_DATATYPES = Collect.unmodifiableSet((Object[])new String[]{"CHAR", "VARCHAR", "TEXT"});
    private final MySqlConnectorConfig connectorConfig;

    protected AbstractMysqlFieldReader(MySqlConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public Object readField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        if (column.jdbcType() == 92) {
            return this.readTimeField(rs, columnIndex);
        }
        if (column.jdbcType() == 91) {
            return this.readDateField(rs, columnIndex, column, table);
        }
        if (column.jdbcType() == 93) {
            return this.readTimestampField(rs, columnIndex, column, table);
        }
        if (column.jdbcType() == -6 || column.jdbcType() == 5) {
            return rs.getObject(columnIndex) == null ? null : Integer.valueOf(rs.getInt(columnIndex));
        }
        if (!this.connectorConfig.customConverterRegistry().isEmpty() && TEXT_DATATYPES.contains(column.typeName())) {
            try {
                return rs.getString(columnIndex).getBytes(column.charsetName());
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Unsupported encoding '{}' for column '{}', sending value as String");
                return rs.getObject(columnIndex);
            }
        }
        return rs.getObject(columnIndex);
    }

    protected abstract Object readTimeField(ResultSet var1, int var2) throws SQLException;

    protected abstract Object readDateField(ResultSet var1, int var2, Column var3, Table var4) throws SQLException;

    protected abstract Object readTimestampField(ResultSet var1, int var2, Column var3, Table var4) throws SQLException;

    protected void logInvalidValue(ResultSet resultSet, int columnIndex, Object value) throws SQLException {
        String columnName = resultSet.getMetaData().getColumnName(columnIndex);
        this.logger.trace("Column '" + columnName + "', detected an invalid value of '" + value + "'");
    }
}

