/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.AbstractMysqlFieldReader;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlBinaryProtocolFieldReader
extends AbstractMysqlFieldReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlBinaryProtocolFieldReader.class);

    public MysqlBinaryProtocolFieldReader(MySqlConnectorConfig config) {
        super(config);
    }

    @Override
    protected Object readTimeField(ResultSet rs, int columnIndex) throws SQLException {
        Blob b = rs.getBlob(columnIndex);
        if (b == null) {
            return null;
        }
        if (b.length() == 0L) {
            LOGGER.warn("Encountered a zero length blob for column index {}", (Object)columnIndex);
            return null;
        }
        if (b.length() != 8L && b.length() != 12L) {
            this.logInvalidValue(rs, columnIndex, b);
            throw new RuntimeException(String.format("Invalid length when read MySQL TIME value. BIN_LEN_TIME is %d. Enable TRACE logging to log the problematic column and its value.", b.length()));
        }
        byte[] bytes = b.getBytes(1L, (int)b.length());
        int days = bytes[1] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[3] & 0xFF) << 16 | (bytes[4] & 0xFF) << 24;
        byte hours = bytes[5];
        byte minutes = bytes[6];
        byte seconds = bytes[7];
        int nanos = 1000 * days;
        int finalHours = (bytes[0] == 1 ? days * -1 : days) * 24 + hours;
        return MySqlValueConverters.stringToDuration(String.format("%d:%d:%d.%d", finalHours, (int)minutes, (int)seconds, nanos));
    }

    @Override
    protected Object readDateField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(columnIndex);
        if (b == null) {
            return null;
        }
        if (b.length() != 4L) {
            this.logInvalidValue(rs, columnIndex, b);
            throw new RuntimeException(String.format("Invalid length when read MySQL DATE value. BIN_LEN_DATE is %d. Enable TRACE logging to log the problematic column and its value.", b.length()));
        }
        byte[] bytes = b.getBytes(1L, (int)b.length());
        int year = bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8;
        byte month = bytes[2];
        byte day = bytes[3];
        return MySqlValueConverters.stringToLocalDate(String.format("%d-%d-%d", year, (int)month, (int)day), column, table);
    }

    @Override
    protected Object readTimestampField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(columnIndex);
        if (b == null) {
            return null;
        }
        if (b.length() == 0L) {
            LOGGER.warn("Encountered a zero length blob for column index {}", (Object)columnIndex);
            return null;
        }
        if (b.length() != 4L && b.length() != 7L && b.length() != 11L) {
            this.logInvalidValue(rs, columnIndex, b);
            throw new RuntimeException(String.format("Invalid length when read MySQL DATETIME value. BIN_LEN_DATETIME is %d. Enable TRACE logging to log the problematic column and its value.", b.length()));
        }
        byte[] bytes = b.getBytes(1L, (int)b.length());
        int year = bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8;
        byte month = bytes[2];
        byte day = bytes[3];
        byte hours = 0;
        byte minutes = 0;
        byte seconds = 0;
        int nanos = 0;
        if (bytes.length > 4) {
            hours = bytes[4];
            minutes = bytes[5];
            seconds = bytes[6];
        }
        if (bytes.length > 7) {
            nanos = 1000 * (bytes[7] & 0xFF | (bytes[8] & 0xFF) << 8 | (bytes[9] & 0xFF) << 16 | (bytes[10] & 0xFF) << 24);
        }
        return MySqlValueConverters.containsZeroValuesInDatePart(String.format("%d-%d-%d %d:%d:%d.%d", year, (int)month, (int)day, (int)hours, (int)minutes, (int)seconds, nanos), column, table) ? null : rs.getTimestamp(columnIndex, Calendar.getInstance());
    }
}

