/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.CdcSourceTaskContext;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private final ObjectName name;
    private volatile boolean registered = false;

    protected Metrics(CdcSourceTaskContext taskContext, String contextName) {
        this.name = this.metricName(taskContext.getConnectorType(), taskContext.getConnectorName(), contextName);
    }

    protected Metrics(CommonConnectorConfig connectorConfig, String contextName) {
        this.name = this.metricName(connectorConfig.getContextName(), connectorConfig.getLogicalName(), contextName);
    }

    public synchronized void register() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (mBeanServer == null) {
                LOGGER.info("JMX not supported, bean '{}' not registered", (Object)this.name);
                return;
            }
            mBeanServer.registerMBean(this, this.name);
            this.registered = true;
        }
        catch (JMException e) {
            throw new RuntimeException("Unable to register the MBean '" + this.name + "'", e);
        }
    }

    public final void unregister() {
        if (this.name != null && this.registered) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mBeanServer == null) {
                    LOGGER.debug("JMX not supported, bean '{}' not registered", (Object)this.name);
                    return;
                }
                mBeanServer.unregisterMBean(this.name);
                this.registered = false;
            }
            catch (JMException e) {
                throw new RuntimeException("Unable to unregister the MBean '" + this.name + "'", e);
            }
        }
    }

    public ObjectName metricName(String connectorType, String connectorName, String contextName) {
        String metricName = "debezium." + connectorType.toLowerCase() + ":type=connector-metrics,context=" + contextName + ",server=" + connectorName;
        try {
            return new ObjectName(metricName);
        }
        catch (MalformedObjectNameException e) {
            throw new ConnectException("Invalid metric name '" + metricName + "'");
        }
    }
}

