/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import com.mysql.cj.CharsetMapping;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, false, converters, tableFilter);
    }

    public MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, boolean includeComments, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews, includeComments);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser((TokenStream)commonTokenStream);
    }

    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    protected boolean isGrammarInUpperCase() {
        return true;
    }

    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{212}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{212, 228}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{213}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{223}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{224}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{225}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{226}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{504}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{504, 228}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{214}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{212, 216}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{213, 216}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{223, 216}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{224, 216}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{225, 216}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{226, 216}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{504, 216}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{214, 216}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{25}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{25, 228})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{215, 213}).setSuffixTokens(new Integer[]{216}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{215, 25}).setSuffixTokens(new Integer[]{216}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{504, 213}).setSuffixTokens(new Integer[]{216})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{215, 212, 228}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{215, 25, 228})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, new Integer[]{186}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{191}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{187}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{192}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{188}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{193}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{189}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{190}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{196}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{194}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{197}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{195}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(7, new Integer[]{198}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{199}).setSuffixTokens(new Integer[]{200, 587, 173, 185}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{203}).setSuffixTokens(new Integer[]{200, 587, 173, 185}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{201}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{202}).setSuffixTokens(new Integer[]{587, 173, 185}), new DataTypeResolver.DataTypeEntry(3, new Integer[]{204}).setSuffixTokens(new Integer[]{587, 173, 185}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{205}).setSuffixTokens(new Integer[]{587, 173, 185}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{418}).setSuffixTokens(new Integer[]{587, 173, 185}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, new Integer[]{206}).setSuffixTokens(new Integer[]{587, 173, 185}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, new Integer[]{333}), new DataTypeResolver.DataTypeEntry(92, new Integer[]{208}), new DataTypeResolver.DataTypeEntry(2014, new Integer[]{209}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{210}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{216}), new DataTypeResolver.DataTypeEntry(-3, new Integer[]{217}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{219}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{211})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, new Integer[]{207}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{218}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{220}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{222}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{335}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{336}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{229})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{227}).setSuffixTokens(new Integer[]{216}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{146}).setSuffixTokens(new Integer[]{216})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, new Integer[]{769}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{770}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{772}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{773}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{774}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{775}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{776}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{777}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{452}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{771})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, new Integer[]{221}).setSuffixTokens(new Integer[]{217})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, new Integer[]{221}).setSuffixTokens(new Integer[]{213})));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes((ParserRuleContext)uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote((char)c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes((String)indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && !ce.defaultValueExpression().isPresent()) {
                    ce.unsetDefaultValueExpression();
                }
                tableEditor.addColumn(ce.create());
            }
            return columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public String extractCharset(MySqlParser.CharsetNameContext charsetNode, MySqlParser.CollationNameContext collationNode) {
        String charsetName = null;
        if (charsetNode != null && charsetNode.getText() != null) {
            charsetName = MySqlAntlrDdlParser.withoutQuotes((String)charsetNode.getText());
        } else if (collationNode != null && collationNode.getText() != null) {
            String collationName = MySqlAntlrDdlParser.withoutQuotes((String)collationNode.getText()).toLowerCase();
            for (int index = 0; index < 1024; ++index) {
                if (!collationName.equals(CharsetMapping.getStaticCollationNameForCollationIndex((Integer)index))) continue;
                charsetName = CharsetMapping.getStaticMysqlCharsetNameForCollationIndex((Integer)index);
                break;
            }
        }
        return charsetName;
    }
}

