/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MysqlFieldReader;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMysqlFieldReader
implements MysqlFieldReader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object readField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        if (column.jdbcType() == 92) {
            return this.readTimeField(rs, columnIndex);
        }
        if (column.jdbcType() == 91) {
            return this.readDateField(rs, columnIndex, column, table);
        }
        if (column.jdbcType() == 93) {
            return this.readTimestampField(rs, columnIndex, column, table);
        }
        if (column.jdbcType() == -6 || column.jdbcType() == 5) {
            return rs.getObject(columnIndex) == null ? null : Integer.valueOf(rs.getInt(columnIndex));
        }
        if ("CHAR".equals(column.typeName()) || "VARCHAR".equals(column.typeName()) || "TEXT".equals(column.typeName())) {
            return rs.getBytes(columnIndex);
        }
        return rs.getObject(columnIndex);
    }

    protected abstract Object readTimeField(ResultSet var1, int var2) throws SQLException;

    protected abstract Object readDateField(ResultSet var1, int var2, Column var3, Table var4) throws SQLException;

    protected abstract Object readTimestampField(ResultSet var1, int var2, Column var3, Table var4) throws SQLException;
}

