/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.mysql.MySqlDefaultValueConverter;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.AbstractDdlParser;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.SchemaNameAdjuster;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class MySqlDefaultValueTest {
    protected AbstractDdlParser parser;
    protected Tables tables;
    private MySqlValueConverters converters;
    private TableSchemaBuilder tableSchemaBuilder;

    @Before
    public void beforeEach() {
        this.converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES);
        this.parser = new MySqlAntlrDdlParser(this.converters);
        this.tables = new Tables();
        this.tableSchemaBuilder = new TableSchemaBuilder((ValueConverterProvider)this.converters, (DefaultValueConverter)new MySqlDefaultValueConverter(this.converters), SchemaNameAdjuster.create(), new CustomConverterRegistry(null), SchemaBuilder.struct().build(), false, false);
    }

    @Test
    public void parseUnsignedTinyintDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_TINYINT_TABLE (    A TINYINT UNSIGNED NULL DEFAULT 0,    B TINYINT UNSIGNED NULL DEFAULT '10',    C TINYINT UNSIGNED NULL,    D TINYINT UNSIGNED NOT NULL,    E TINYINT UNSIGNED NOT NULL DEFAULT 0,    F TINYINT UNSIGNED NOT NULL DEFAULT '0',    G TINYINT UNSIGNED NOT NULL DEFAULT '255');";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_TINYINT_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isNull();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo((Object)255);
    }

    @Test
    public void parseUnsignedSmallintDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_SMALLINT_TABLE (\n  A SMALLINT UNSIGNED NULL DEFAULT 0,\n  B SMALLINT UNSIGNED NULL DEFAULT '10',\n  C SMALLINT UNSIGNED NULL,\n  D SMALLINT UNSIGNED NOT NULL,\n  E SMALLINT UNSIGNED NOT NULL DEFAULT 0,\n  F SMALLINT UNSIGNED NOT NULL DEFAULT '0',\n  G SMALLINT UNSIGNED NOT NULL DEFAULT '65535'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_SMALLINT_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)this.getColumnSchema(table, "D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)this.getColumnSchema(table, "E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo((Object)65535);
    }

    @Test
    public void parseUnsignedMediumintDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_MEDIUMINT_TABLE (\n  A MEDIUMINT UNSIGNED NULL DEFAULT 0,\n  B MEDIUMINT UNSIGNED NULL DEFAULT '10',\n  C MEDIUMINT UNSIGNED NULL,\n  D MEDIUMINT UNSIGNED NOT NULL,\n  E MEDIUMINT UNSIGNED NOT NULL DEFAULT 0,\n  F MEDIUMINT UNSIGNED NOT NULL DEFAULT '0',\n  G MEDIUMINT UNSIGNED NOT NULL DEFAULT '16777215'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_MEDIUMINT_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo((Object)0xFFFFFF);
    }

    @Test
    public void parseUnsignedIntDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_INT_TABLE (\n  A INT UNSIGNED NULL DEFAULT 0,\n  B INT UNSIGNED NULL DEFAULT '10',\n  C INT UNSIGNED NULL,\n  D INT UNSIGNED NOT NULL,\n  E INT UNSIGNED NOT NULL DEFAULT 0,\n  F INT UNSIGNED NOT NULL DEFAULT '0',\n  G INT UNSIGNED NOT NULL DEFAULT '4294967295'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_INT_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)10L);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo((Object)0xFFFFFFFFL);
    }

    @Test
    public void parseUnsignedBigIntDefaultValueToLong() {
        String sql = "CREATE TABLE UNSIGNED_BIGINT_TABLE (\n  A BIGINT UNSIGNED NULL DEFAULT 0,\n  B BIGINT UNSIGNED NULL DEFAULT '10',\n  C BIGINT UNSIGNED NULL,\n  D BIGINT UNSIGNED NOT NULL,\n  E BIGINT UNSIGNED NOT NULL DEFAULT 0,\n  F BIGINT UNSIGNED NOT NULL DEFAULT '0'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_BIGINT_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)10L);
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)this.getColumnSchema(table, "D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)this.getColumnSchema(table, "E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)0L);
    }

    @Test
    public void parseUnsignedBigIntDefaultValueToBigDecimal() {
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.PRECISE, CommonConnectorConfig.BinaryHandlingMode.BYTES);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser(converters);
        TableSchemaBuilder tableSchemaBuilder = new TableSchemaBuilder((ValueConverterProvider)converters, (DefaultValueConverter)new MySqlDefaultValueConverter(converters), SchemaNameAdjuster.create(), new CustomConverterRegistry(null), SchemaBuilder.struct().build(), false, false);
        String sql = "CREATE TABLE UNSIGNED_BIGINT_TABLE (\n  A BIGINT UNSIGNED NULL DEFAULT 0,\n  B BIGINT UNSIGNED NULL DEFAULT '10',\n  C BIGINT UNSIGNED NULL,\n  D BIGINT UNSIGNED NOT NULL,\n  E BIGINT UNSIGNED NOT NULL DEFAULT 0,\n  F BIGINT UNSIGNED NOT NULL DEFAULT '0',\n  G BIGINT UNSIGNED NOT NULL DEFAULT '18446744073709551615'\n);";
        parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_BIGINT_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A", tableSchemaBuilder).defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B", tableSchemaBuilder).defaultValue()).isEqualTo((Object)new BigDecimal(10));
        Assertions.assertThat((boolean)table.columnWithName("C").isOptional()).isEqualTo(true);
        Assertions.assertThat((boolean)table.columnWithName("C").hasDefaultValue()).isTrue();
        Assertions.assertThat((boolean)table.columnWithName("D").isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)table.columnWithName("D").hasDefaultValue()).isFalse();
        Assertions.assertThat((boolean)table.columnWithName("E").isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E", tableSchemaBuilder).defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F", tableSchemaBuilder).defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        Assertions.assertThat((Object)this.getColumnSchema(table, "G", tableSchemaBuilder).defaultValue()).isEqualTo((Object)new BigDecimal("18446744073709551615"));
    }

    @Test
    public void parseStringDefaultValue() {
        String sql = "CREATE TABLE UNSIGNED_STRING_TABLE (\n  A CHAR NULL DEFAULT 'A',\n  B CHAR CHARACTER SET utf8 NULL DEFAULT 'b',\n  C VARCHAR(10) NULL DEFAULT 'CC',\n  D NCHAR(10) NULL DEFAULT '10',\n  E NVARCHAR NULL DEFAULT '0',\n  F CHAR DEFAULT NULL,\n  G VARCHAR(10) DEFAULT NULL,\n  H NCHAR(10) DEFAULT NULL\n) CHARACTER SET 'latin2';";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "UNSIGNED_STRING_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)"A");
        Assertions.assertThat((String)table.columnWithName("A").charsetName()).isEqualTo((Object)"latin2");
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)"b");
        Assertions.assertThat((String)table.columnWithName("B").charsetName()).isEqualTo((Object)"utf8");
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isEqualTo((Object)"CC");
        Assertions.assertThat((Object)this.getColumnSchema(table, "D").defaultValue()).isEqualTo((Object)"10");
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)"0");
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)this.getColumnSchema(table, "H").defaultValue()).isEqualTo(null);
    }

    @Test
    public void parseBitDefaultValue() {
        String sql = "CREATE TABLE BIT_TABLE (\n  A BIT(1) NULL DEFAULT NULL,\n  B BIT(1) DEFAULT 0,\n  C BIT(1) DEFAULT 1,\n  D BIT(1) DEFAULT b'0',\n  E BIT(1) DEFAULT b'1',\n  F BIT(1) DEFAULT TRUE,\n  G BIT(1) DEFAULT FALSE,\n  H BIT(10) DEFAULT b'101000010',\n  I BIT(10) DEFAULT NULL,\n  J BIT(25) DEFAULT b'10110000100001111'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "BIT_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)this.getColumnSchema(table, "D").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "H").defaultValue()).isEqualTo((Object)new byte[]{66, 1});
        Assertions.assertThat((Object)this.getColumnSchema(table, "I").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)this.getColumnSchema(table, "J").defaultValue()).isEqualTo((Object)new byte[]{15, 97, 1, 0});
    }

    @Test
    public void parseBooleanDefaultValue() {
        String sql = "CREATE TABLE BOOLEAN_TABLE (\n  A BOOLEAN NULL DEFAULT 0,\n  B BOOLEAN NOT NULL DEFAULT '1',\n  C BOOLEAN NOT NULL DEFAULT '9',\n  D BOOLEAN NOT NULL DEFAULT TRUE,\n  E BOOLEAN DEFAULT NULL\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "BOOLEAN_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)this.getColumnSchema(table, "D").defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo(null);
    }

    @Test
    public void parseNumberDefaultValue() {
        String sql = "CREATE TABLE NUMBER_TABLE (\n  A TINYINT NULL DEFAULT 10,\n  B SMALLINT NOT NULL DEFAULT '5',\n  C INTEGER NOT NULL DEFAULT 0,\n  D BIGINT NOT NULL DEFAULT 20,\n  E INT NULL DEFAULT NULL,\n  F FLOAT NULL DEFAULT 0,\n  G DOUBLE NOT NULL DEFAULT 1.0\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "NUMBER_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)5);
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "D").defaultValue()).isEqualTo((Object)20L);
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)0.0);
    }

    @Test
    public void parseRealDefaultValue() {
        String sql = "CREATE TABLE REAL_TABLE (\n  A REAL NOT NULL DEFAULT 1,\n  B REAL NULL DEFAULT NULL \n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "REAL_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo(null);
    }

    @Test
    public void parseNumericAndDecimalToDoubleDefaultValue() {
        String sql = "CREATE TABLE NUMERIC_DECIMAL_TABLE (\n  A NUMERIC NOT NULL DEFAULT 1.23,\n  B DECIMAL(5,3) NOT NULL DEFAULT 2.321,\n  C NUMERIC NULL DEFAULT '12.678',\n  D DECIMAL(5,2) NULL DEFAULT '12.678'\n);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "NUMERIC_DECIMAL_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)2.321);
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isEqualTo((Object)13.0);
        Assertions.assertThat((Object)this.getColumnSchema(table, "D").defaultValue()).isEqualTo((Object)12.68);
    }

    @Test
    public void parseNumericAndDecimalToDecimalDefaultValue() {
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser(converters);
        TableSchemaBuilder tableSchemaBuilder = new TableSchemaBuilder((ValueConverterProvider)converters, (DefaultValueConverter)new MySqlDefaultValueConverter(converters), SchemaNameAdjuster.create(), new CustomConverterRegistry(null), SchemaBuilder.struct().build(), false, false);
        String sql = "CREATE TABLE NUMERIC_DECIMAL_TABLE (\n  A NUMERIC NOT NULL DEFAULT 1.23,\n  B DECIMAL(5,3) NOT NULL DEFAULT 2.321,\n  C NUMERIC NULL DEFAULT '12.678'\n);";
        parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "NUMERIC_DECIMAL_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A", tableSchemaBuilder).defaultValue()).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)this.getColumnSchema(table, "B", tableSchemaBuilder).defaultValue()).isEqualTo((Object)BigDecimal.valueOf(2.321));
        Assertions.assertThat((Object)this.getColumnSchema(table, "C", tableSchemaBuilder).defaultValue()).isEqualTo((Object)BigDecimal.valueOf(13L));
    }

    @Test
    public void parseTimeDefaultValue() {
        String sql = "CREATE TABLE TIME_TABLE (  A timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  B timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',  C timestamp NOT NULL DEFAULT '0000-00-00 00:00:00.000',  D timestamp NOT NULL DEFAULT '2018-06-26 12:34:56',  E timestamp NOT NULL DEFAULT '2018-06-26 12:34:56.000',  F timestamp NOT NULL DEFAULT '2018-06-26 12:34:56.78',  G datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  H datetime NOT NULL DEFAULT '0000-00-00 00:00:00',  I datetime(3) NOT NULL DEFAULT '0000-00-00 00:00:00.000',  J datetime NOT NULL DEFAULT '2018-06-26 12:34:56',  K datetime(3) NOT NULL DEFAULT '2018-06-26 12:34:56.000',  L datetime(2) NOT NULL DEFAULT '2018-06-26 12:34:56.78',  M datetime NOT NULL DEFAULT '2000-01-00 00:00:00',  N datetime NOT NULL DEFAULT '0000-12-01 00:00:00',  O datetime NOT NULL DEFAULT '2000-00-01 00:00:00');";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "TIME_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)this.getColumnSchema(table, "D").defaultValue()).isEqualTo((Object)ZonedTimestamp.toIsoString((ZonedDateTime)LocalDateTime.of(2018, 6, 26, 12, 34, 56, 0).atZone(ZoneId.systemDefault()), null));
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)ZonedTimestamp.toIsoString((ZonedDateTime)LocalDateTime.of(2018, 6, 26, 12, 34, 56, 0).atZone(ZoneId.systemDefault()), null));
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)ZonedTimestamp.toIsoString((ZonedDateTime)LocalDateTime.of(2018, 6, 26, 12, 34, 56, 780000000).atZone(ZoneId.systemDefault()), null));
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "H").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "I").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "J").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2018, 6, 26, 12, 34, 56, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)this.getColumnSchema(table, "K").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2018, 6, 26, 12, 34, 56, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)this.getColumnSchema(table, "L").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2018, 6, 26, 12, 34, 56, 780000000, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)this.getColumnSchema(table, "M").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "N").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "O").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
    }

    @Test
    public void parseDateDefaultValue() {
        String sql = "CREATE TABLE DATE_TABLE (  A date NOT NULL DEFAULT '0000-00-00',  B date NOT NULL DEFAULT '2018-00-01',  C date NOT NULL DEFAULT '0000-12-31',  D date NOT NULL DEFAULT '2018-01-00',  E date NOT NULL DEFAULT '9999-09-09',  F date NOT NULL DEFAULT '1111-11-11',  G date NOT NULL DEFAULT '2018-08-31',  H date NOT NULL DEFAULT '2050-01-01 00:00:00',  I date NOT NULL DEFAULT 0);";
        this.parser.parse(sql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "DATE_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "C").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "D").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "E").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(9999, 9, 9, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)this.getColumnSchema(table, "F").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(1111, 11, 11, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)this.getColumnSchema(table, "G").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2018, 8, 31, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)this.getColumnSchema(table, "H").defaultValue()).isEqualTo((Object)Date.from(ZonedDateTime.of(2050, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()));
        Assertions.assertThat((Object)this.getColumnSchema(table, "I").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
    }

    @Test
    @FixFor(value={"DBZ-901"})
    public void parseAlterTableTruncatedDefaulDateTime() {
        String sql = "CREATE TABLE TIME_TABLE (  A datetime(3) NOT NULL DEFAULT '0000-00-00 00:00:00.000');";
        String alterSql = "ALTER TABLE TIME_TABLE ADD COLUMN B DATETIME(3) NOT NULL DEFAULT '1970-01-01 00:00:00';";
        this.parser.parse(sql, this.tables);
        this.parser.parse(alterSql, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "TIME_TABLE"));
        Assertions.assertThat((Object)this.getColumnSchema(table, "A").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
        Assertions.assertThat((Object)this.getColumnSchema(table, "B").defaultValue()).isEqualTo((Object)Date.from(Instant.ofEpochMilli(0L)));
    }

    @Test
    @FixFor(value={"DBZ-870"})
    public void shouldAcceptZeroAsDefaultValueForDateColumn() {
        String ddl = "CREATE TABLE data(id INT, nullable_date date default 0, not_nullable_date date not null default 0, PRIMARY KEY (id))";
        this.parser.parse(ddl, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "data"));
        Assertions.assertThat((boolean)table.columnWithName("nullable_date").hasDefaultValue()).isTrue();
        Assertions.assertThat((Object)this.getColumnSchema(table, "nullable_date").defaultValue()).isNull();
        Assertions.assertThat((boolean)table.columnWithName("not_nullable_date").hasDefaultValue()).isTrue();
        Assertions.assertThat((Object)this.getColumnSchema(table, "not_nullable_date").defaultValue()).isEqualTo((Object)this.getEpochDate());
    }

    private Date getEpochDate() {
        return Date.from(LocalDate.of(1970, 1, 1).atStartOfDay(ZoneId.of("UTC")).toInstant());
    }

    @Test
    @FixFor(value={"DBZ-1204"})
    public void shouldAcceptBooleanAsTinyIntDefaultValue() {
        String ddl = "CREATE TABLE data(id INT, bval BOOLEAN DEFAULT TRUE, tival1 TINYINT(1) DEFAULT FALSE, tival2 TINYINT(1) DEFAULT 3, tival3 TINYINT(2) DEFAULT TRUE, tival4 TINYINT(2) DEFAULT 18, PRIMARY KEY (id))";
        this.parser.parse(ddl, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "data"));
        Assertions.assertThat((Boolean)((Boolean)this.getColumnSchema(table, "bval").defaultValue())).isTrue();
        Assertions.assertThat((Short)((Short)this.getColumnSchema(table, "tival1").defaultValue())).isZero();
        Assertions.assertThat((Short)((Short)this.getColumnSchema(table, "tival2").defaultValue())).isEqualTo((short)3);
        Assertions.assertThat((Short)((Short)this.getColumnSchema(table, "tival3").defaultValue())).isEqualTo((short)1);
        Assertions.assertThat((Short)((Short)this.getColumnSchema(table, "tival4").defaultValue())).isEqualTo((short)18);
    }

    @Test
    @FixFor(value={"DBZ-1689"})
    public void shouldAcceptBooleanAsIntDefaultValue() {
        String ddl = "CREATE TABLE data(id INT, bval BOOLEAN DEFAULT TRUE, ival1 INT(1) DEFAULT FALSE, ival2 INT(1) DEFAULT 3, ival3 INT(2) DEFAULT TRUE, ival4 INT(2) DEFAULT 18, PRIMARY KEY (id))";
        this.parser.parse(ddl, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "data"));
        Assertions.assertThat((Boolean)((Boolean)this.getColumnSchema(table, "bval").defaultValue())).isTrue();
        Assertions.assertThat((Integer)((Integer)this.getColumnSchema(table, "ival1").defaultValue())).isZero();
        Assertions.assertThat((Integer)((Integer)this.getColumnSchema(table, "ival2").defaultValue())).isEqualTo(3);
        Assertions.assertThat((Integer)((Integer)this.getColumnSchema(table, "ival3").defaultValue())).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)this.getColumnSchema(table, "ival4").defaultValue())).isEqualTo(18);
    }

    @Test
    @FixFor(value={"DBZ-1249"})
    public void shouldAcceptBitSetDefaultValue() {
        String ddl = "CREATE TABLE user_subscribe (id bigint(20) unsigned NOT NULL AUTO_INCREMENT, content bit(24) DEFAULT b'111111111111101100001110', PRIMARY KEY (id)) ENGINE=InnoDB";
        this.parser.parse(ddl, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "user_subscribe"));
        byte[] defVal = (byte[])this.getColumnSchema(table, "content").defaultValue();
        Assertions.assertThat((int)Byte.toUnsignedInt(defVal[0])).isEqualTo(14);
        Assertions.assertThat((int)Byte.toUnsignedInt(defVal[1])).isEqualTo(251);
        Assertions.assertThat((int)Byte.toUnsignedInt(defVal[2])).isEqualTo(255);
    }

    @Test
    @FixFor(value={"DBZ-3989"})
    public void shouldTrimNumericalDefaultValueAndShouldNotTrimNonNumericalDefaultValue() {
        String ddl = "CREATE TABLE data(id INT DEFAULT '1 ', data VARCHAR(3) DEFAULT ' 3 ')";
        this.parser.parse(ddl, this.tables);
        Table table = this.tables.forTable(new TableId(null, null, "data"));
        Assertions.assertThat((Integer)((Integer)this.getColumnSchema(table, "id").defaultValue())).isEqualTo(1);
        Assertions.assertThat((String)((String)this.getColumnSchema(table, "data").defaultValue())).isEqualTo((Object)" 3 ");
    }

    private Schema getColumnSchema(Table table, String column) {
        return this.getColumnSchema(table, column, this.tableSchemaBuilder);
    }

    private Schema getColumnSchema(Table table, String column, TableSchemaBuilder tableSchemaBuilder) {
        TableSchema schema = tableSchemaBuilder.create("test", "dummy", table, null, null, null);
        return schema.getEnvelopeSchema().schema().field("after").schema().field(column).schema();
    }
}

