/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.heartbeat;

import io.debezium.config.Field;
import io.debezium.function.BlockingConsumer;
import io.debezium.heartbeat.HeartbeatErrorHandler;
import io.debezium.heartbeat.HeartbeatImpl;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseHeartbeatImpl
extends HeartbeatImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseHeartbeatImpl.class);
    public static final String HEARTBEAT_ACTION_QUERY_PROPERTY_NAME = "heartbeat.action.query";
    public static final Field HEARTBEAT_ACTION_QUERY = Field.create("heartbeat.action.query").withDisplayName("An optional query to execute with every heartbeat").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.ADVANCED_HEARTBEAT, 2)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The query executed with every heartbeat.");
    private final String heartBeatActionQuery;
    private final JdbcConnection jdbcConnection;
    private final HeartbeatErrorHandler errorHandler;

    DatabaseHeartbeatImpl(Duration heartbeatInterval, String topicName, String key, JdbcConnection jdbcConnection, String heartBeatActionQuery, HeartbeatErrorHandler errorHandler) {
        super(heartbeatInterval, topicName, key);
        this.heartBeatActionQuery = heartBeatActionQuery;
        this.jdbcConnection = jdbcConnection;
        this.errorHandler = errorHandler;
    }

    @Override
    public void forcedBeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        try {
            this.jdbcConnection.execute(this.heartBeatActionQuery);
        }
        catch (SQLException e) {
            if (this.errorHandler != null) {
                this.errorHandler.onError(e);
            }
            LOGGER.error("Could not execute heartbeat action (Error: " + e.getSQLState() + ")", (Throwable)e);
        }
        LOGGER.debug("Executed heartbeat action query");
        super.forcedBeat(partition, offset, consumer);
    }
}

