/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlReadOnlyIncrementalSnapshotContext;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlReadOnlyIncrementalSnapshotChangeEventSource<T extends DataCollectionId>
extends AbstractIncrementalSnapshotChangeEventSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlReadOnlyIncrementalSnapshotChangeEventSource.class);
    private final String showMasterStmt = "SHOW MASTER STATUS";

    public MySqlReadOnlyIncrementalSnapshotChangeEventSource(CommonConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<T> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener progressListener, DataChangeEventListener dataChangeEventListener) {
        super(config, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener);
    }

    public void processMessage(Partition partition, DataCollectionId dataCollectionId, Object key, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        LOGGER.trace("Checking window for table '{}', key '{}', window contains '{}'", new Object[]{dataCollectionId, key, this.window});
        boolean windowClosed = this.getContext().updateWindowState(offsetContext);
        if (windowClosed) {
            this.sendWindowEvents(partition, offsetContext);
            this.readChunk();
        } else if (!this.window.isEmpty() && this.getContext().deduplicationNeeded()) {
            this.deduplicateWindow(dataCollectionId, key);
        }
    }

    public void processHeartbeat(Partition partition, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        while (this.getContext().snapshotRunning() && this.getContext().reachedHighWatermark(offsetContext)) {
            this.sendWindowEvents(partition, offsetContext);
            this.readChunk();
        }
    }

    public void processFilteredEvent(Partition partition, OffsetContext offsetContext) throws InterruptedException {
        if (this.getContext() == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        boolean windowClosed = this.getContext().updateWindowState(offsetContext);
        if (windowClosed) {
            this.sendWindowEvents(partition, offsetContext);
            this.readChunk();
        }
    }

    protected void updateLowWatermark() {
        try {
            this.getExecutedGtidSet(this.getContext()::setLowWatermark);
            this.jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    protected void updateHighWatermark() {
        this.getExecutedGtidSet(this.getContext()::setHighWatermark);
    }

    private void getExecutedGtidSet(Consumer<GtidSet> watermark) {
        try {
            this.jdbcConnection.query("SHOW MASTER STATUS", rs -> {
                if (rs.next()) {
                    if (rs.getMetaData().getColumnCount() > 4) {
                        String gtidSet = rs.getString(5);
                        watermark.accept(new GtidSet(gtidSet));
                    } else {
                        throw new UnsupportedOperationException("Need to add support for executed GTIDs for versions prior to 5.6.5");
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    protected void emitWindowOpen() {
        this.updateLowWatermark();
    }

    protected void emitWindowClose() throws InterruptedException {
        this.updateHighWatermark();
        if (this.getContext().serverUuidChanged()) {
            this.rereadChunk();
        }
    }

    public void rereadChunk() throws InterruptedException {
        if (this.context == null) {
            return;
        }
        if (!this.context.snapshotRunning() || !this.context.deduplicationNeeded() || this.window.isEmpty()) {
            return;
        }
        this.window.clear();
        this.context.revertChunk();
        this.readChunk();
    }

    private MySqlReadOnlyIncrementalSnapshotContext<T> getContext() {
        return (MySqlReadOnlyIncrementalSnapshotContext)this.context;
    }
}

