/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MySqlReadOnlyIncrementalSnapshotContext<T>
extends AbstractIncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlReadOnlyIncrementalSnapshotContext.class);
    private GtidSet lowWatermark = null;
    private GtidSet highWatermark = null;

    public MySqlReadOnlyIncrementalSnapshotContext() {
        this(true);
    }

    public MySqlReadOnlyIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        super(useCatalogBeforeSchema);
    }

    public static <U> MySqlReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets) {
        return MySqlReadOnlyIncrementalSnapshotContext.load(offsets, true);
    }

    public static <U> MySqlReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets, boolean useCatalogBeforeSchema) {
        MySqlReadOnlyIncrementalSnapshotContext context = new MySqlReadOnlyIncrementalSnapshotContext(useCatalogBeforeSchema);
        MySqlReadOnlyIncrementalSnapshotContext.init(context, offsets);
        return context;
    }

    public void setLowWatermark(GtidSet lowWatermark) {
        this.lowWatermark = lowWatermark;
    }

    public void setHighWatermark(GtidSet highWatermark) {
        this.highWatermark = highWatermark.subtract(this.lowWatermark);
    }

    public boolean updateWindowState(OffsetContext offsetContext) {
        String currentGtid = offsetContext.getSourceInfo().getString("gtid");
        if (!this.windowOpened && this.lowWatermark != null) {
            boolean pastLowWatermark;
            boolean bl = pastLowWatermark = !this.lowWatermark.contains(currentGtid);
            if (pastLowWatermark) {
                LOGGER.debug("Current gtid {}, low watermark {}", (Object)currentGtid, (Object)this.lowWatermark);
                this.windowOpened = true;
                this.lowWatermark = null;
            }
        }
        if (this.windowOpened && this.highWatermark != null) {
            boolean pastHighWatermark;
            boolean bl = pastHighWatermark = !this.highWatermark.contains(currentGtid);
            if (pastHighWatermark) {
                LOGGER.debug("Current gtid {}, high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
                this.windowOpened = false;
                this.highWatermark = null;
                return true;
            }
        }
        return false;
    }

    public boolean reachedHighWatermark(OffsetContext offsetContext) {
        long maxTransactionId;
        String currentGtid = offsetContext.getSourceInfo().getString("gtid");
        if (this.highWatermark == null) {
            return false;
        }
        if (currentGtid == null) {
            return true;
        }
        String[] gtid = GtidSet.GTID_DELIMITER.split(currentGtid);
        GtidSet.UUIDSet uuidSet = this.highWatermark.forServerWithId(gtid[0]);
        if (uuidSet != null && (maxTransactionId = uuidSet.getIntervals().stream().mapToLong(GtidSet.Interval::getEnd).max().getAsLong()) <= Long.parseLong(gtid[1])) {
            LOGGER.debug("Heartbeat {} reached high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
            this.windowOpened = false;
            this.highWatermark = null;
            this.lowWatermark = null;
            return true;
        }
        return false;
    }

    public boolean serverUuidChanged() {
        return this.highWatermark.getUUIDSets().size() > 1;
    }
}

