/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.IncrementalSnapshotIT;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.junit.SkipTestDependingOnGtidModeRule;
import io.debezium.connector.mysql.junit.SkipWhenGtidModeIs;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenGtidModeIs(value=SkipWhenGtidModeIs.GtidMode.OFF, reason="Read only connection requires GTID_MODE to be ON")
public class ReadOnlyIncrementalSnapshotIT
extends IncrementalSnapshotIT {
    public static final String EXCLUDED_TABLE = "b";
    @Rule
    public TestRule skipTest = new SkipTestDependingOnGtidModeRule();

    @Override
    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)super.config().with(MySqlConnectorConfig.TABLE_EXCLUDE_LIST, this.DATABASE.getDatabaseName() + "." + EXCLUDED_TABLE)).with(MySqlConnectorConfig.READ_ONLY_CONNECTION, true);
    }

    @Test
    public void filteredEvents() throws Exception {
        Testing.Print.enable();
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        Thread t = new Thread(() -> {
            try {
                JdbcConnection connection = this.databaseConnection();
                try {
                    connection.setAutoCommit(false);
                    int i = 0;
                    while (true) {
                        connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (pk, aa) VALUES (%s, %s)", EXCLUDED_TABLE, i + 1000 + 1, i + 1000)});
                        connection.commit();
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        t.setDaemon(true);
        t.setName("filtered-binlog-events-thread");
        t.start();
        int expectedRecordCount = 1000;
        Map dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((Map)dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test(expected=ConnectException.class)
    @SkipWhenGtidModeIs(value=SkipWhenGtidModeIs.GtidMode.ON, reason="Read only connection requires GTID_MODE to be ON")
    public void shouldFailIfGtidModeIsOff() throws Exception {
        Testing.Print.enable();
        this.populateTable();
        AtomicReference exception = new AtomicReference();
        this.startConnector((success, message, error) -> exception.set(error));
        ReadOnlyIncrementalSnapshotIT.waitForConnectorShutdown((String)"mysql", (String)this.DATABASE.getServerName());
        this.stopConnector();
        Throwable e = (Throwable)exception.get();
        if (e != null) {
            throw (RuntimeException)e;
        }
    }
}

