/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import com.mysql.cj.CharsetMapping;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, converters, tableFilter);
    }

    protected MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser((TokenStream)commonTokenStream);
    }

    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    protected boolean isGrammarInUpperCase() {
        return true;
    }

    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{207}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{207, 223}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{208}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{218}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{219}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{220}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{221}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{483}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{483, 223}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{209}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{207, 211}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{208, 211}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{218, 211}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{219, 211}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{220, 211}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{221, 211}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{483, 211}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{209, 211}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{22}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{22, 223})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{210, 208}).setSuffixTokens(new Integer[]{211}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{210, 22}).setSuffixTokens(new Integer[]{211}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{483, 208}).setSuffixTokens(new Integer[]{211})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{210, 207, 223}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{210, 22, 223})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, new Integer[]{181}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{186}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{182}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{187}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{183}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{188}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{184}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{185}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{191}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{189}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{192}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{190}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(7, new Integer[]{193}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{194}).setSuffixTokens(new Integer[]{195, 564, 168, 180}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{198}).setSuffixTokens(new Integer[]{195, 564, 168, 180}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{196}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{197}).setSuffixTokens(new Integer[]{564, 168, 180}), new DataTypeResolver.DataTypeEntry(3, new Integer[]{199}).setSuffixTokens(new Integer[]{564, 168, 180}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{200}).setSuffixTokens(new Integer[]{564, 168, 180}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{398}).setSuffixTokens(new Integer[]{564, 168, 180}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, new Integer[]{201}).setSuffixTokens(new Integer[]{564, 168, 180}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, new Integer[]{317}), new DataTypeResolver.DataTypeEntry(92, new Integer[]{203}), new DataTypeResolver.DataTypeEntry(2014, new Integer[]{204}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{205}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{211}), new DataTypeResolver.DataTypeEntry(-3, new Integer[]{212}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{214}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{206})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, new Integer[]{202}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{213}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{215}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{217}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{319}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{320}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{224})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{222}).setSuffixTokens(new Integer[]{211}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{141}).setSuffixTokens(new Integer[]{211})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, new Integer[]{744}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{745}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{747}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{748}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{749}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{750}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{751}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{752}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{431}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{746})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, new Integer[]{216}).setSuffixTokens(new Integer[]{212})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, new Integer[]{216}).setSuffixTokens(new Integer[]{208})));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes((ParserRuleContext)uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote((char)c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes((String)indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && ce.defaultValue() == null) {
                    ce.unsetDefaultValue();
                }
                tableEditor.addColumn(ce.create());
            }
            return columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public String extractCharset(MySqlParser.CharsetNameContext charsetNode, MySqlParser.CollationNameContext collationNode) {
        String charsetName = null;
        if (charsetNode != null && charsetNode.getText() != null) {
            charsetName = MySqlAntlrDdlParser.withoutQuotes((String)charsetNode.getText());
        } else if (collationNode != null && collationNode.getText() != null) {
            String collationName = MySqlAntlrDdlParser.withoutQuotes((String)collationNode.getText()).toLowerCase();
            for (int index = 0; index < 2048; ++index) {
                if (!collationName.equals(CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME[index])) continue;
                charsetName = CharsetMapping.getMysqlCharsetNameForCollationIndex((Integer)index);
                break;
            }
        }
        return charsetName;
    }
}

