/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlSnapshotChangeEventSource;
import io.debezium.connector.mysql.MySqlSnapshotChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSource;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.function.BlockingConsumer;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;

public class MySqlChangeEventSourceFactory
implements ChangeEventSourceFactory {
    private final MySqlConnectorConfig configuration;
    private final MySqlConnection connection;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final MySqlTaskContext taskContext;
    private final MySqlStreamingChangeEventSourceMetrics streamingMetrics;
    private final MySqlDatabaseSchema schema;
    private final ChangeEventQueue<DataChangeEvent> queue;

    public MySqlChangeEventSourceFactory(MySqlConnectorConfig configuration, MySqlConnection connection, ErrorHandler errorHandler, EventDispatcher<TableId> dispatcher, Clock clock, MySqlDatabaseSchema schema, MySqlTaskContext taskContext, MySqlStreamingChangeEventSourceMetrics streamingMetrics, ChangeEventQueue<DataChangeEvent> queue) {
        this.configuration = configuration;
        this.connection = connection;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.taskContext = taskContext;
        this.streamingMetrics = streamingMetrics;
        this.queue = queue;
        this.schema = schema;
    }

    public SnapshotChangeEventSource getSnapshotChangeEventSource(OffsetContext offsetContext, SnapshotProgressListener snapshotProgressListener) {
        return new MySqlSnapshotChangeEventSource(this.configuration, (MySqlOffsetContext)offsetContext, this.connection, this.taskContext.getSchema(), this.dispatcher, this.clock, (MySqlSnapshotChangeEventSourceMetrics)snapshotProgressListener, (BlockingConsumer<Function<SourceRecord, SourceRecord>>)((BlockingConsumer)record -> this.modifyAndFlushLastRecord((Function<SourceRecord, SourceRecord>)record)));
    }

    private void modifyAndFlushLastRecord(Function<SourceRecord, SourceRecord> modify) throws InterruptedException {
        this.queue.flushBuffer(dataChange -> new DataChangeEvent((SourceRecord)modify.apply(dataChange.getRecord())));
        this.queue.disableBuffering();
    }

    public StreamingChangeEventSource getStreamingChangeEventSource(OffsetContext offsetContext) {
        this.queue.disableBuffering();
        return new MySqlStreamingChangeEventSource(this.configuration, (MySqlOffsetContext)offsetContext, this.connection, this.dispatcher, this.errorHandler, this.clock, this.taskContext, this.streamingMetrics);
    }

    public Optional<IncrementalSnapshotChangeEventSource<? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(OffsetContext offsetContext, SnapshotProgressListener snapshotProgressListener, DataChangeEventListener dataChangeEventListener) {
        SignalBasedIncrementalSnapshotChangeEventSource incrementalSnapshotChangeEventSource = new SignalBasedIncrementalSnapshotChangeEventSource((CommonConnectorConfig)this.configuration, (JdbcConnection)this.connection, (DatabaseSchema)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener);
        return Optional.of(incrementalSnapshotChangeEventSource);
    }
}

