/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.GtidSet;
import io.debezium.annotation.Immutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public final class GtidSet {
    private final Map<String, UUIDSet> uuidSetsByServerId = new TreeMap<String, UUIDSet>();

    protected GtidSet(Map<String, UUIDSet> uuidSetsByServerId) {
        this.uuidSetsByServerId.putAll(uuidSetsByServerId);
    }

    public GtidSet(String gtids) {
        gtids = gtids.replaceAll("\n", "").replaceAll("\r", "");
        new com.github.shyiko.mysql.binlog.GtidSet(gtids).getUUIDSets().forEach(uuidSet -> this.uuidSetsByServerId.put(uuidSet.getUUID(), new UUIDSet((GtidSet.UUIDSet)uuidSet)));
        StringBuilder sb = new StringBuilder();
        this.uuidSetsByServerId.values().forEach(uuidSet -> {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(uuidSet.toString());
        });
    }

    public GtidSet retainAll(Predicate<String> sourceFilter) {
        if (sourceFilter == null) {
            return this;
        }
        Map<String, UUIDSet> newSets = this.uuidSetsByServerId.entrySet().stream().filter(entry -> sourceFilter.test((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new GtidSet(newSets);
    }

    public Collection<UUIDSet> getUUIDSets() {
        return Collections.unmodifiableCollection(this.uuidSetsByServerId.values());
    }

    public UUIDSet forServerWithId(String uuid) {
        return this.uuidSetsByServerId.get(uuid);
    }

    public boolean isContainedWithin(GtidSet other) {
        if (other == null) {
            return false;
        }
        if (this.equals(other)) {
            return true;
        }
        for (UUIDSet uuidSet : this.uuidSetsByServerId.values()) {
            UUIDSet thatSet;
            if (uuidSet.isContainedWithin(thatSet = other.forServerWithId(uuidSet.getUUID()))) continue;
            return false;
        }
        return true;
    }

    public GtidSet with(GtidSet other) {
        if (other == null || other.uuidSetsByServerId.isEmpty()) {
            return this;
        }
        HashMap<String, UUIDSet> newSet = new HashMap<String, UUIDSet>();
        newSet.putAll(this.uuidSetsByServerId);
        newSet.putAll(other.uuidSetsByServerId);
        return new GtidSet(newSet);
    }

    public GtidSet getGtidSetBeginning() {
        HashMap<String, UUIDSet> newSet = new HashMap<String, UUIDSet>();
        for (UUIDSet uuidSet : this.uuidSetsByServerId.values()) {
            newSet.put(uuidSet.getUUID(), uuidSet.asIntervalBeginning());
        }
        return new GtidSet(newSet);
    }

    public int hashCode() {
        return this.uuidSetsByServerId.keySet().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GtidSet) {
            GtidSet that = (GtidSet)obj;
            return this.uuidSetsByServerId.equals(that.uuidSetsByServerId);
        }
        return false;
    }

    public String toString() {
        ArrayList<String> gtids = new ArrayList<String>();
        for (UUIDSet uuidSet : this.uuidSetsByServerId.values()) {
            gtids.add(uuidSet.toString());
        }
        return String.join((CharSequence)",", gtids);
    }

    @Immutable
    public static class Interval
    implements Comparable<Interval> {
        private final long start;
        private final long end;

        public Interval(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public boolean isContainedWithin(Interval other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            return this.getStart() >= other.getStart() && this.getEnd() <= other.getEnd();
        }

        @Override
        public int compareTo(Interval that) {
            if (that == this) {
                return 0;
            }
            long diff = this.start - that.start;
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        public int hashCode() {
            return (int)this.getStart();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Interval) {
                Interval that = (Interval)obj;
                return this.getStart() == that.getStart() && this.getEnd() == that.getEnd();
            }
            return false;
        }

        public String toString() {
            return this.getStart() + "-" + this.getEnd();
        }
    }

    @Immutable
    public static class UUIDSet {
        private final String uuid;
        private final LinkedList<Interval> intervals = new LinkedList();

        protected UUIDSet(GtidSet.UUIDSet uuidSet) {
            this.uuid = uuidSet.getUUID();
            uuidSet.getIntervals().forEach(interval -> this.intervals.add(new Interval(interval.getStart(), interval.getEnd())));
            Collections.sort(this.intervals);
            if (this.intervals.size() > 1) {
                for (int i = this.intervals.size() - 1; i != 0; --i) {
                    Interval before = this.intervals.get(i - 1);
                    Interval after = this.intervals.get(i);
                    if (before.getEnd() + 1L != after.getStart()) continue;
                    this.intervals.set(i - 1, new Interval(before.getStart(), after.getEnd()));
                    this.intervals.remove(i);
                }
            }
        }

        protected UUIDSet(String uuid, Interval interval) {
            this.uuid = uuid;
            this.intervals.add(interval);
        }

        public UUIDSet asIntervalBeginning() {
            Interval start = new Interval(this.intervals.get(0).getStart(), this.intervals.get(0).getStart());
            return new UUIDSet(this.uuid, start);
        }

        public String getUUID() {
            return this.uuid;
        }

        public List<Interval> getIntervals() {
            return Collections.unmodifiableList(this.intervals);
        }

        public boolean isContainedWithin(UUIDSet other) {
            if (other == null) {
                return false;
            }
            if (!this.getUUID().equalsIgnoreCase(other.getUUID())) {
                return false;
            }
            if (this.intervals.isEmpty()) {
                return true;
            }
            if (other.intervals.isEmpty()) {
                return false;
            }
            assert (this.intervals.size() > 0);
            assert (other.intervals.size() > 0);
            for (Interval thisInterval : this.intervals) {
                boolean found = false;
                for (Interval otherInterval : other.intervals) {
                    if (!thisInterval.isContainedWithin(otherInterval)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UUIDSet) {
                UUIDSet that = (UUIDSet)obj;
                return this.getUUID().equalsIgnoreCase(that.getUUID()) && this.getIntervals().equals(that.getIntervals());
            }
            return super.equals(obj);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(this.uuid).append(':');
            Iterator iter = this.intervals.iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
            }
            while (iter.hasNext()) {
                sb.append(':');
                sb.append(iter.next());
            }
            return sb.toString();
        }
    }
}

