/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlBinaryModeIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-binary-mode.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("binarymodeit", "binary_mode_test").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveRawBinary() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.BYTES)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Debug.enable();
        int createDatabaseCount = 1;
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(createDatabaseCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        ByteBuffer expectedValue = ByteBuffer.wrap(new byte[]{1, 2, 3});
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(arg_0 -> ((MySqlBinaryModeIT)this).validate(arg_0));
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveHexBinary() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.HEX)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Debug.enable();
        int createDatabaseCount = 1;
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(createDatabaseCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        String expectedValue = "010203";
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(arg_0 -> ((MySqlBinaryModeIT)this).validate(arg_0));
    }

    @Test
    @FixFor(value={"DBZ-1814"})
    public void shouldReceiveBase64Binary() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.BinaryHandlingMode.BASE64)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Debug.enable();
        int createDatabaseCount = 1;
        int createTableCount = 1;
        int insertCount = 1;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(createDatabaseCount + createTableCount + insertCount);
        this.stopConnector();
        Assertions.assertThat((Object)sourceRecords).isNotNull();
        List topicSourceRecords = sourceRecords.recordsForTopic(this.DATABASE.topicForTable("dbz_1814_binary_mode_test"));
        Assertions.assertThat((List)topicSourceRecords).hasSize(1);
        SourceRecord topicSourceRecord = (SourceRecord)topicSourceRecords.get(0);
        Struct kafkaDataStructure = (Struct)((Struct)topicSourceRecord.value()).get("after");
        String expectedValue = "AQID";
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("blob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("tinyblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("mediumblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("longblob_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("binary_col"));
        Assert.assertEquals((Object)expectedValue, (Object)kafkaDataStructure.get("varbinary_col"));
        sourceRecords.forEach(arg_0 -> ((MySqlBinaryModeIT)this).validate(arg_0));
    }
}

