/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.io;

import com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;

public class ByteArrayInputStream
extends InputStream {
    private InputStream inputStream;
    private Integer peek;
    private Integer pos;
    private Integer markPosition;
    private int blockLength = -1;

    public ByteArrayInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.pos = 0;
    }

    public ByteArrayInputStream(byte[] bytes) {
        this(new java.io.ByteArrayInputStream(bytes));
    }

    public int readInteger(int length) throws IOException {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result |= this.read() << (i << 3);
        }
        return result;
    }

    public long readLong(int length) throws IOException {
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result |= (long)this.read() << (i << 3);
        }
        return result;
    }

    public String readString(int length) throws IOException {
        return new String(this.read(length));
    }

    public String readLengthEncodedString() throws IOException {
        return this.readString(this.readPackedInteger());
    }

    public String readZeroTerminatedString() throws IOException {
        int b;
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        while ((b = this.read()) != 0) {
            s.writeInteger(b, 1);
        }
        return new String(s.toByteArray());
    }

    public byte[] read(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.fill(bytes, 0, length);
        return bytes;
    }

    public void fill(byte[] bytes, int offset, int length) throws IOException {
        int read;
        for (int remaining = length; remaining != 0; remaining -= read) {
            read = this.read(bytes, offset + length - remaining, remaining);
            if (read != -1) continue;
            throw new EOFException();
        }
    }

    public BitSet readBitSet(int length, boolean bigEndian) throws IOException {
        byte[] bytes = this.read(length + 7 >> 3);
        bytes = bigEndian ? bytes : this.reverse(bytes);
        BitSet result = new BitSet();
        for (int i = 0; i < length; ++i) {
            if ((bytes[i >> 3] & 1 << i % 8) == 0) continue;
            result.set(i);
        }
        return result;
    }

    private byte[] reverse(byte[] bytes) {
        int length = bytes.length >> 1;
        for (int i = 0; i < length; ++i) {
            int j = bytes.length - 1 - i;
            byte t = bytes[i];
            bytes[i] = bytes[j];
            bytes[j] = t;
        }
        return bytes;
    }

    public int readPackedInteger() throws IOException {
        Number number = this.readPackedNumber();
        if (number == null) {
            throw new IOException("Unexpected NULL where int should have been");
        }
        if (number.longValue() > Integer.MAX_VALUE) {
            throw new IOException("Stumbled upon long even though int expected");
        }
        return number.intValue();
    }

    public Number readPackedNumber() throws IOException {
        int b = this.read();
        if (b < 251) {
            return b;
        }
        if (b == 251) {
            return null;
        }
        if (b == 252) {
            return (long)this.readInteger(2);
        }
        if (b == 253) {
            return (long)this.readInteger(3);
        }
        if (b == 254) {
            return this.readLong(8);
        }
        throw new IOException("Unexpected packed number byte " + b);
    }

    @Override
    public int available() throws IOException {
        if (this.blockLength != -1) {
            return this.blockLength;
        }
        return this.inputStream.available();
    }

    public int peek() throws IOException {
        if (this.peek == null) {
            this.peek = this.readWithinBlockBoundaries();
        }
        return this.peek;
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.peek == null) {
            result = this.readWithinBlockBoundaries();
        } else {
            result = this.peek;
            this.peek = null;
        }
        if (result == -1) {
            throw new EOFException();
        }
        this.pos = this.pos + 1;
        return result;
    }

    private int readWithinBlockBoundaries() throws IOException {
        if (this.blockLength != -1) {
            if (this.blockLength == 0) {
                return -1;
            }
            --this.blockLength;
        }
        return this.inputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public void enterBlock(int length) {
        this.blockLength = length < -1 ? -1 : length;
    }

    public void skipToTheEndOfTheBlock() throws IOException {
        if (this.blockLength != -1) {
            this.skip(this.blockLength);
            this.blockLength = -1;
        }
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markPosition = this.pos;
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.pos = this.markPosition;
        this.inputStream.reset();
    }

    public synchronized long fastSkip(long n) throws IOException {
        long skipOf = n;
        if (this.blockLength != -1) {
            skipOf = Math.min((long)this.blockLength, skipOf);
            this.blockLength = (int)((long)this.blockLength - skipOf);
            if (this.blockLength == 0) {
                this.blockLength = -1;
            }
        }
        this.pos = this.pos + (int)skipOf;
        return this.inputStream.skip(skipOf);
    }
}

