/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mysql.legacy.MySqlSchema;
import io.debezium.connector.mysql.legacy.MySqlTaskContext;
import io.debezium.connector.mysql.legacy.SnapshotReaderMetricsMXBean;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import java.util.concurrent.atomic.AtomicBoolean;

class SnapshotReaderMetrics
extends SnapshotChangeEventSourceMetrics
implements SnapshotReaderMetricsMXBean {
    private final AtomicBoolean holdingGlobalLock = new AtomicBoolean();
    private final MySqlSchema schema;

    public SnapshotReaderMetrics(MySqlTaskContext taskContext, MySqlSchema schema, ChangeEventQueueMetrics changeEventQueueMetrics) {
        super((CdcSourceTaskContext)taskContext, changeEventQueueMetrics, null);
        this.schema = schema;
    }

    @Override
    public boolean getHoldingGlobalLock() {
        return this.holdingGlobalLock.get();
    }

    public void globalLockAcquired() {
        this.holdingGlobalLock.set(true);
    }

    public void globalLockReleased() {
        this.holdingGlobalLock.set(false);
    }

    public String[] getMonitoredTables() {
        return this.schema.monitoredTablesAsStringArray();
    }

    public long getTotalNumberOfEventsSeen() {
        return this.getRowsScanned().values().stream().mapToLong(x -> x).sum();
    }
}

