/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public class MySqlOffsetContext
implements OffsetContext {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String GTID_SET_KEY = "gtids";
    public static final String NON_GTID_TRANSACTION_ID_FORMAT = "file=%s,pos=%s";
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private final Map<String, String> partition;
    private boolean snapshotCompleted;
    private final TransactionContext transactionContext;
    private String restartGtidSet;
    private String currentGtidSet;
    private String restartBinlogFilename;
    private long restartBinlogPosition = 0L;
    private int restartRowsToSkip = 0;
    private long restartEventsToSkip = 0L;
    private long currentEventLengthInBytes = 0L;
    private boolean inTransaction = false;
    private String transactionId = null;

    public MySqlOffsetContext(MySqlConnectorConfig connectorConfig, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, SourceInfo sourceInfo) {
        this.partition = Collections.singletonMap(SERVER_PARTITION_KEY, connectorConfig.getLogicalName());
        this.sourceInfo = sourceInfo;
        this.sourceInfoSchema = sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.transactionContext = transactionContext;
    }

    public MySqlOffsetContext(MySqlConnectorConfig connectorConfig, boolean snapshot, boolean snapshotCompleted, SourceInfo sourceInfo) {
        this(connectorConfig, snapshot, snapshotCompleted, new TransactionContext(), sourceInfo);
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        Map<String, Object> offset = this.offsetUsingPosition(this.restartRowsToSkip);
        if (this.sourceInfo.isSnapshot()) {
            if (!this.snapshotCompleted) {
                offset.put("snapshot", true);
            }
        } else {
            return this.transactionContext.store(offset);
        }
        return offset;
    }

    private Map<String, Object> offsetUsingPosition(long rowsToSkip) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.sourceInfo.getServerId() != 0L) {
            map.put("server_id", this.sourceInfo.getServerId());
        }
        if (this.restartGtidSet != null) {
            map.put(GTID_SET_KEY, this.restartGtidSet);
        }
        map.put("file", this.restartBinlogFilename);
        map.put("pos", this.restartBinlogPosition);
        if (this.restartEventsToSkip != 0L) {
            map.put(EVENTS_TO_SKIP_OFFSET_KEY, this.restartEventsToSkip);
        }
        if (rowsToSkip != 0L) {
            map.put("row", rowsToSkip);
        }
        if (this.sourceInfo.timestamp() != null) {
            map.put(TIMESTAMP_KEY, this.sourceInfo.timestamp().getEpochSecond());
        }
        return map;
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    private void setTransactionId() {
        this.transactionId = this.sourceInfo.getCurrentGtid() != null ? this.sourceInfo.getCurrentGtid() : String.format(NON_GTID_TRANSACTION_ID_FORMAT, this.restartBinlogFilename, this.restartBinlogPosition);
    }

    private void resetTransactionId() {
        this.transactionId = null;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setInitialSkips(long restartEventsToSkip, int restartRowsToSkip) {
        this.restartEventsToSkip = restartEventsToSkip;
        this.restartRowsToSkip = restartRowsToSkip;
    }

    public static MySqlOffsetContext initial(MySqlConnectorConfig config) {
        MySqlOffsetContext offset = new MySqlOffsetContext(config, false, false, new SourceInfo(config));
        offset.setBinlogStartPoint("", 0L);
        return offset;
    }

    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.tableEvent((TableId)tableId);
    }

    public void databaseEvent(String database, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.databaseEvent(database);
        this.sourceInfo.tableEvent((TableId)null);
    }

    public void tableEvent(String database, Set<TableId> tableIds, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.databaseEvent(database);
        this.sourceInfo.tableEvent(tableIds);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void setBinlogStartPoint(String binlogFilename, long positionOfFirstEvent) {
        assert (positionOfFirstEvent >= 0L);
        if (binlogFilename != null) {
            this.sourceInfo.setBinlogPosition(binlogFilename, positionOfFirstEvent);
            this.restartBinlogFilename = binlogFilename;
        } else {
            this.sourceInfo.setBinlogPosition(this.sourceInfo.getCurrentBinlogFilename(), positionOfFirstEvent);
        }
        this.restartBinlogPosition = positionOfFirstEvent;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
    }

    public void setCompletedGtidSet(String gtidSet) {
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = trimmedGtidSet;
        }
    }

    public String gtidSet() {
        return this.currentGtidSet != null ? this.currentGtidSet : null;
    }

    public void startGtid(String gtid, String gtidSet) {
        this.sourceInfo.startGtid(gtid);
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = this.currentGtidSet != null ? this.currentGtidSet : trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet;
        }
    }

    public SourceInfo getSource() {
        return this.sourceInfo;
    }

    public void startNextTransaction() {
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.restartBinlogFilename = this.sourceInfo.binlogFilename();
        this.restartBinlogPosition = this.sourceInfo.binlogPosition();
        this.inTransaction = true;
        this.setTransactionId();
    }

    public void commitTransaction() {
        this.restartGtidSet = this.currentGtidSet;
        this.restartBinlogFilename = this.sourceInfo.binlogFilename();
        this.restartBinlogPosition = this.sourceInfo.binlogPosition() + this.currentEventLengthInBytes;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.inTransaction = false;
        this.sourceInfo.setQuery(null);
        this.resetTransactionId();
    }

    public void completeEvent() {
        ++this.restartEventsToSkip;
    }

    public void setEventPosition(long positionOfCurrentEvent, long eventSizeInBytes) {
        this.sourceInfo.setEventPosition(positionOfCurrentEvent);
        this.currentEventLengthInBytes = eventSizeInBytes;
        if (!this.inTransaction) {
            this.restartBinlogPosition = positionOfCurrentEvent + eventSizeInBytes;
            this.restartRowsToSkip = 0;
            this.restartEventsToSkip = 0L;
        }
    }

    public void setQuery(String query) {
        this.sourceInfo.setQuery(query);
    }

    public void changeEventCompleted() {
        this.restartRowsToSkip = 0;
    }

    public long eventsToSkipUponRestart() {
        return this.restartEventsToSkip;
    }

    public int rowsToSkipUponRestart() {
        return this.restartRowsToSkip;
    }

    public void setRowNumber(int eventRowNumber, int totalNumberOfRows) {
        this.sourceInfo.setRowNumber(eventRowNumber);
        this.restartRowsToSkip = eventRowNumber < totalNumberOfRows - 1 ? eventRowNumber + 1 : totalNumberOfRows;
    }

    public void setBinlogThread(long threadId) {
        this.sourceInfo.setBinlogServerId(threadId);
    }

    public String toString() {
        return "MySqlOffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + (Object)((Object)this.sourceInfo) + ", partition=" + this.partition + ", snapshotCompleted=" + this.snapshotCompleted + ", transactionContext=" + this.transactionContext + ", restartGtidSet=" + this.restartGtidSet + ", currentGtidSet=" + this.currentGtidSet + ", restartBinlogFilename=" + this.restartBinlogFilename + ", restartBinlogPosition=" + this.restartBinlogPosition + ", restartRowsToSkip=" + this.restartRowsToSkip + ", restartEventsToSkip=" + this.restartEventsToSkip + ", currentEventLengthInBytes=" + this.currentEventLengthInBytes + ", inTransaction=" + this.inTransaction + ", transactionId=" + this.transactionId + "]";
    }

    public static class Loader
    implements OffsetContext.Loader {
        private final MySqlConnectorConfig connectorConfig;

        public Loader(MySqlConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Map<String, ?> getPartition() {
            return Collections.singletonMap(MySqlOffsetContext.SERVER_PARTITION_KEY, this.connectorConfig.getLogicalName());
        }

        public OffsetContext load(Map<String, ?> offset) {
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot")) || "true".equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(MySqlOffsetContext.SNAPSHOT_COMPLETED_KEY)) || "true".equals(offset.get(MySqlOffsetContext.SNAPSHOT_COMPLETED_KEY));
            String binlogFilename = (String)offset.get("file");
            if (binlogFilename == null) {
                throw new ConnectException("Source offset 'file' parameter is missing");
            }
            long binlogPosition = this.longOffsetValue(offset, "pos");
            MySqlOffsetContext offsetContext = new MySqlOffsetContext(this.connectorConfig, snapshot, snapshotCompleted, TransactionContext.load(offset), new SourceInfo(this.connectorConfig));
            offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
            offsetContext.setInitialSkips(this.longOffsetValue(offset, MySqlOffsetContext.EVENTS_TO_SKIP_OFFSET_KEY), (int)this.longOffsetValue(offset, "row"));
            offsetContext.setCompletedGtidSet((String)offset.get(MySqlOffsetContext.GTID_SET_KEY));
            return offsetContext;
        }

        private long longOffsetValue(Map<String, ?> values, String key) {
            Object obj = values.get(key);
            if (obj == null) {
                return 0L;
            }
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            try {
                return Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
            }
        }
    }
}

