/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

class MySqlEventMetadataProvider
implements EventMetadataProvider {
    MySqlEventMetadataProvider() {
    }

    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        Long timestamp = sourceInfo.getInt64("ts_ms");
        return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
    }

    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        return Collect.hashMapOf((Object)"file", (Object)sourceInfo.getString("file"), (Object)"pos", (Object)Long.toString(sourceInfo.getInt64("pos")), (Object)"row", (Object)Integer.toString(sourceInfo.getInt32("row")));
    }

    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        return sourceInfo.getString("gtid");
    }
}

