/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.legacy.MySqlJdbcContext;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnection
extends JdbcConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(MySqlConnection.class);
    private static final String SQL_SHOW_SYSTEM_VARIABLES = "SHOW VARIABLES";
    private static final String SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET = "SHOW VARIABLES WHERE Variable_name IN ('character_set_server','collation_server')";
    private static final String SQL_SHOW_SESSION_VARIABLE_SSL_VERSION = "SHOW SESSION STATUS LIKE 'Ssl_version'";
    protected static final String URL_PATTERN = "jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useSSL=${useSSL}&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}";
    private final Map<String, String> originalSystemProperties = new HashMap<String, String>();
    private final MySqlConnectionConfiguration connectionConfig;

    public MySqlConnection(MySqlConnectionConfiguration connectionConfig) {
        super(connectionConfig.config(), connectionConfig.factory());
        this.connectionConfig = connectionConfig;
    }

    public synchronized Connection connection(boolean executeOnConnect) throws SQLException {
        if (!this.isConnected() && this.connectionConfig.sslModeEnabled()) {
            this.originalSystemProperties.clear();
            this.setSystemProperty("javax.net.ssl.keyStore", MySqlConnectorConfig.SSL_KEYSTORE, true);
            this.setSystemProperty("javax.net.ssl.keyStorePassword", MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD, false);
            this.setSystemProperty("javax.net.ssl.trustStore", MySqlConnectorConfig.SSL_TRUSTSTORE, true);
            this.setSystemProperty("javax.net.ssl.trustStorePassword", MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD, false);
        }
        return super.connection(executeOnConnect);
    }

    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            this.originalSystemProperties.forEach((name, value) -> {
                if (value != null) {
                    System.setProperty(name, value);
                } else {
                    System.clearProperty(name);
                }
            });
        }
    }

    protected Map<String, String> readMySqlCharsetSystemVariables() {
        LOGGER.debug("Reading MySQL charset-related system variables before parsing DDL history.");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET);
    }

    protected Map<String, String> readMySqlSystemVariables() {
        LOGGER.debug("Reading MySQL system variables");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES);
    }

    private Map<String, String> querySystemVariables(String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            this.query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                    LOGGER.debug("\t{} = {}", (Object)Strings.pad((String)varName, (int)45, (char)' '), (Object)Strings.pad((String)value, (int)45, (char)' '));
                }
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }

    protected String setStatementFor(Map<String, String> variables) {
        StringBuilder sb = new StringBuilder("SET ");
        boolean first = true;
        ArrayList<String> varNames = new ArrayList<String>(variables.keySet());
        Collections.sort(varNames);
        for (String varName : varNames) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(varName).append("=");
            String value = variables.get(varName);
            if (value == null) {
                value = "";
            }
            if (value.contains(",") || value.contains(";")) {
                value = "'" + value + "'";
            }
            sb.append(value);
        }
        return sb.append(";").toString();
    }

    protected void setSystemProperty(String property, Field field, boolean showValueInError) {
        String value = this.connectionConfig.config().getString(field);
        if (value != null) {
            value = value.trim();
            String existingValue = System.getProperty(property);
            if (existingValue == null) {
                String existing = System.setProperty(property, value);
                this.originalSystemProperties.put(property, existing);
            } else if (!(existingValue = existingValue.trim()).equalsIgnoreCase(value)) {
                String msg = "System or JVM property '" + property + "' is already defined, but the configuration property '" + field.name() + "' defines a different value";
                if (showValueInError) {
                    msg = "System or JVM property '" + property + "' is already defined as " + existingValue + ", but the configuration property '" + field.name() + "' defines a different value '" + value + "'";
                }
                throw new DebeziumException(msg);
            }
        }
    }

    protected String getSessionVariableForSslVersion() {
        String SSL_VERSION = "Ssl_version";
        LOGGER.debug("Reading MySQL Session variable for Ssl Version");
        Map<String, String> sessionVariables = this.querySystemVariables(SQL_SHOW_SESSION_VARIABLE_SSL_VERSION);
        if (!sessionVariables.isEmpty() && sessionVariables.containsKey("Ssl_version")) {
            return sessionVariables.get("Ssl_version");
        }
        return null;
    }

    public boolean isGtidModeEnabled() {
        try {
            return (Boolean)this.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    return !"OFF".equalsIgnoreCase(rs.getString(2));
                }
                return false;
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
    }

    public String knownGtidSet() {
        try {
            return (String)this.queryAndMap("SHOW MASTER STATUS", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 4) {
                    return rs.getString(5);
                }
                return "";
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
    }

    public GtidSet subtractGtidSet(GtidSet set1, GtidSet set2) {
        try {
            return (GtidSet)this.prepareQueryAndMap("SELECT GTID_SUBTRACT(?, ?)", ps -> {
                ps.setString(1, set1.toString());
                ps.setString(2, set2.toString());
            }, rs -> {
                if (rs.next()) {
                    return new GtidSet(rs.getString(1));
                }
                return new GtidSet("");
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
    }

    public GtidSet purgedGtidSet() {
        try {
            return (GtidSet)this.queryAndMap("SELECT @@global.gtid_purged", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 0) {
                    return new GtidSet(rs.getString(1));
                }
                return new GtidSet("");
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking at gtid_purged variable: ", (Throwable)e);
        }
    }

    public boolean userHasPrivileges(String grantName) {
        try {
            return (Boolean)this.queryAndMap("SHOW GRANTS FOR CURRENT_USER", rs -> {
                while (rs.next()) {
                    String grants = rs.getString(1);
                    LOGGER.debug(grants);
                    if (grants == null) {
                        return false;
                    }
                    if (!(grants = grants.toUpperCase()).contains("ALL") && !grants.contains(grantName.toUpperCase())) continue;
                    return true;
                }
                return false;
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking at privileges for current user: ", (Throwable)e);
        }
    }

    public String earliestBinlogFilename() {
        ArrayList logNames = new ArrayList();
        try {
            LOGGER.info("Checking all known binlogs from MySQL");
            this.query("SHOW BINARY LOGS", rs -> {
                while (rs.next()) {
                    logNames.add(rs.getString(1));
                }
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking for binary logs: ", (Throwable)e);
        }
        if (logNames.isEmpty()) {
            return null;
        }
        return (String)logNames.get(0);
    }

    protected boolean isBinlogRowImageFull() {
        try {
            String rowImage = (String)this.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'binlog_row_image'", rs -> {
                if (rs.next()) {
                    return rs.getString(2);
                }
                return "FULL";
            });
            LOGGER.debug("binlog_row_image={}", (Object)rowImage);
            return "FULL".equalsIgnoreCase(rowImage);
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking at BINLOG_ROW_IMAGE mode: ", (Throwable)e);
        }
    }

    protected boolean isBinlogFormatRow() {
        try {
            String mode = (String)this.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'binlog_format'", rs -> rs.next() ? rs.getString(2) : "");
            LOGGER.debug("binlog_format={}", (Object)mode);
            return "ROW".equalsIgnoreCase(mode);
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking at BINLOG_FORMAT mode: ", (Throwable)e);
        }
    }

    public List<String> availableBinlogFiles() {
        ArrayList<String> logNames = new ArrayList<String>();
        try {
            LOGGER.info("Get all known binlogs from MySQL");
            this.query("SHOW BINARY LOGS", rs -> {
                while (rs.next()) {
                    logNames.add(rs.getString(1));
                }
            });
            return logNames;
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to MySQL and looking for binary logs: ", (Throwable)e);
        }
    }

    public OptionalLong getEstimatedTableSize(TableId tableId) {
        try {
            this.execute(new String[]{"USE `" + tableId.catalog() + "`;"});
            return (OptionalLong)this.queryAndMap("SHOW TABLE STATUS LIKE '" + tableId.table() + "';", rs -> {
                if (rs.next()) {
                    return OptionalLong.of(rs.getLong(5));
                }
                return OptionalLong.empty();
            });
        }
        catch (SQLException e) {
            LOGGER.debug("Error while getting number of rows in table {}: {}", new Object[]{tableId, e.getMessage(), e});
            return OptionalLong.empty();
        }
    }

    protected Map<String, MySqlJdbcContext.DatabaseLocales> readDatabaseCollations() {
        LOGGER.debug("Reading default database charsets");
        try {
            return (Map)this.queryAndMap("SELECT schema_name, default_character_set_name, default_collation_name FROM information_schema.schemata", rs -> {
                HashMap<String, MySqlJdbcContext.DatabaseLocales> charsets = new HashMap<String, MySqlJdbcContext.DatabaseLocales>();
                while (rs.next()) {
                    String dbName = rs.getString(1);
                    String charset = rs.getString(2);
                    String collation = rs.getString(3);
                    if (dbName == null || charset == null && collation == null) continue;
                    charsets.put(dbName, new MySqlJdbcContext.DatabaseLocales(charset, collation));
                    LOGGER.debug("\t{} = {}, {}", new Object[]{Strings.pad((String)dbName, (int)45, (char)' '), Strings.pad((String)charset, (int)45, (char)' '), Strings.pad((String)collation, (int)45, (char)' ')});
                }
                return charsets;
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Error reading default database charsets: " + e.getMessage(), (Throwable)e);
        }
    }

    public String connectionString() {
        return this.connectionString(URL_PATTERN);
    }

    public static class MySqlConnectionConfiguration {
        protected static final String JDBC_PROPERTY_LEGACY_DATETIME = "useLegacyDatetimeCode";
        private final Configuration jdbcConfig;
        private final JdbcConnection.ConnectionFactory factory;
        private final Configuration config;

        public MySqlConnectionConfiguration(Configuration config) {
            this.config = config;
            boolean useSSL = this.sslModeEnabled();
            Configuration dbConfig = ((Configuration.Builder)config.filter(x -> !x.startsWith("database.history.") && !x.equals(MySqlConnectorConfig.DATABASE_HISTORY.name())).edit().withDefault(MySqlConnectorConfig.PORT, MySqlConnectorConfig.PORT.defaultValue())).build().subset("database.", true);
            Configuration.Builder jdbcConfigBuilder = dbConfig.edit().with("connectTimeout", Long.toString(this.getConnectionTimeout().toMillis())).with("useSSL", Boolean.toString(useSSL));
            String legacyDateTime = dbConfig.getString(JDBC_PROPERTY_LEGACY_DATETIME);
            if (legacyDateTime == null) {
                jdbcConfigBuilder.with(JDBC_PROPERTY_LEGACY_DATETIME, "false");
            } else if ("true".equals(legacyDateTime)) {
                LOGGER.warn("'{}' is set to 'true'. This setting is not recommended and can result in timezone issues.", (Object)JDBC_PROPERTY_LEGACY_DATETIME);
            }
            this.jdbcConfig = jdbcConfigBuilder.build();
            String driverClassName = this.jdbcConfig.getString(MySqlConnectorConfig.JDBC_DRIVER);
            this.factory = JdbcConnection.patternBasedFactory((String)MySqlConnection.URL_PATTERN, (String)driverClassName, (ClassLoader)this.getClass().getClassLoader(), (Field[])new Field[0]);
        }

        public Configuration config() {
            return this.jdbcConfig;
        }

        public JdbcConnection.ConnectionFactory factory() {
            return this.factory;
        }

        public String username() {
            return this.config.getString(MySqlConnectorConfig.USER);
        }

        public String password() {
            return this.config.getString(MySqlConnectorConfig.PASSWORD);
        }

        public String hostname() {
            return this.config.getString(MySqlConnectorConfig.HOSTNAME);
        }

        public int port() {
            return this.config.getInteger(MySqlConnectorConfig.PORT);
        }

        public MySqlConnectorConfig.SecureConnectionMode sslMode() {
            String mode = this.config.getString(MySqlConnectorConfig.SSL_MODE);
            return MySqlConnectorConfig.SecureConnectionMode.parse(mode);
        }

        public boolean sslModeEnabled() {
            return this.sslMode() != MySqlConnectorConfig.SecureConnectionMode.DISABLED;
        }

        public Duration getConnectionTimeout() {
            return Duration.ofMillis(this.config.getLong(MySqlConnectorConfig.CONNECTION_TIMEOUT_MS));
        }

        public CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode() {
            String mode = this.config.getString(CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE);
            if (mode == null) {
                mode = this.config.getString(MySqlConnectorConfig.EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE);
            }
            return CommonConnectorConfig.EventProcessingFailureHandlingMode.parse((String)mode);
        }

        public CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaHandlingMode() {
            String mode = this.config.getString(MySqlConnectorConfig.INCONSISTENT_SCHEMA_HANDLING_MODE);
            return CommonConnectorConfig.EventProcessingFailureHandlingMode.parse((String)mode);
        }
    }
}

