/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlGeometry;
import io.debezium.data.geometry.Point;
import javax.xml.bind.DatatypeConverter;
import org.junit.Assert;
import org.junit.Test;

public class MySqlGeometryTest {
    @Test
    public void shouldConvertMySqlBytesToPoint() throws Exception {
        byte[] mysqlBytes = DatatypeConverter.parseHexBinary((String)"000000000101000000e3a59bc420f01b4015a143a69d383240");
        MySqlGeometry geom = MySqlGeometry.fromBytes((byte[])mysqlBytes);
        Assert.assertTrue((boolean)geom.isPoint());
        Assert.assertEquals((Object)geom.getSrid(), null);
        double[] coords = Point.parseWKBPoint((byte[])geom.getWkb());
        Assert.assertEquals((double)coords[0], (double)6.9845, (double)1.0E-4);
        Assert.assertEquals((double)coords[1], (double)18.22115554, (double)1.0E-4);
    }

    @Test
    public void shouldConvertMySqlBytesToLine() throws Exception {
        byte[] mysqlBytes = DatatypeConverter.parseHexBinary((String)"E6100000010200000002000000E3A59BC420F01B4015A143A69D38324000000000000000000000000000000000");
        MySqlGeometry geom = MySqlGeometry.fromBytes((byte[])mysqlBytes);
        Assert.assertFalse((boolean)geom.isPoint());
        Assert.assertEquals((Object)4326, (Object)geom.getSrid());
        Assert.assertEquals((Object)"010200000002000000E3A59BC420F01B4015A143A69D38324000000000000000000000000000000000", (Object)DatatypeConverter.printHexBinary((byte[])geom.getWkb()));
    }

    @Test
    public void shouldConvertMySqlBytesToPolygon() throws Exception {
        byte[] mysqlBytes = DatatypeConverter.parseHexBinary((String)"E61000000103000000010000000400000000000000000000000000000000000000000000000000F03F000000000000F03F000000000000F03F000000000000000000000000000000000000000000000000");
        MySqlGeometry geom = MySqlGeometry.fromBytes((byte[])mysqlBytes);
        Assert.assertFalse((boolean)geom.isPoint());
        Assert.assertEquals((Object)geom.getSrid(), (Object)4326);
        Assert.assertEquals((Object)"0103000000010000000400000000000000000000000000000000000000000000000000F03F000000000000F03F000000000000F03F000000000000000000000000000000000000000000000000", (Object)DatatypeConverter.printHexBinary((byte[])geom.getWkb()));
    }

    @Test
    public void shouldConvertMySqlBytesToGeomCollection() throws Exception {
        byte[] mysqlBytes = DatatypeConverter.parseHexBinary((String)"730C00000107000000020000000101000000000000000000F03F000000000000F03F01020000000200000000000000000000000000000000000000000000000000F03F000000000000F03F");
        MySqlGeometry geom = MySqlGeometry.fromBytes((byte[])mysqlBytes);
        Assert.assertFalse((boolean)geom.isPoint());
        Assert.assertEquals((Object)geom.getSrid(), (Object)3187);
        Assert.assertEquals((Object)"0107000000020000000101000000000000000000F03F000000000000F03F01020000000200000000000000000000000000000000000000000000000000F03F000000000000F03F", (Object)DatatypeConverter.printHexBinary((byte[])geom.getWkb()));
    }

    @Test
    public void shouldConvertMySqlBytesToMultiGeometry() throws Exception {
        byte[] mysqlBytes = DatatypeConverter.parseHexBinary((String)"000000000104000000020000000101000000000000000000F03F000000000000F03F010100000000000000000000400000000000000040");
        MySqlGeometry geom = MySqlGeometry.fromBytes((byte[])mysqlBytes);
        Assert.assertFalse((boolean)geom.isPoint());
        Assert.assertEquals((Object)geom.getSrid(), null);
        Assert.assertEquals((Object)"0104000000020000000101000000000000000000F03F000000000000F03F010100000000000000000000400000000000000040", (Object)DatatypeConverter.printHexBinary((byte[])geom.getWkb()));
    }
}

