/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class MySqlOffsetContext
implements OffsetContext {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private final Map<String, String> partition;
    private boolean snapshotCompleted;
    private final TransactionContext transactionContext;
    private final MySqlConnectorConfig connectorConfig;

    public MySqlOffsetContext(MySqlConnectorConfig connectorConfig, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, SourceInfo sourceInfo) {
        this.connectorConfig = connectorConfig;
        this.partition = Collections.singletonMap(SERVER_PARTITION_KEY, connectorConfig.getLogicalName());
        this.sourceInfo = sourceInfo;
        this.sourceInfoSchema = sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.transactionContext = transactionContext;
    }

    public MySqlOffsetContext(MySqlConnectorConfig connectorConfig, boolean snapshot, boolean snapshotCompleted, SourceInfo sourceInfo) {
        this(connectorConfig, snapshot, snapshotCompleted, new TransactionContext(), sourceInfo);
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        Map<String, ?> offset = this.sourceInfo.offset();
        if (!this.sourceInfo.isSnapshot()) {
            return this.transactionContext.store(offset);
        }
        return offset;
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
        this.sourceInfo.startSnapshot();
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
        this.sourceInfo.markLastSnapshot(this.connectorConfig.getConfig());
    }

    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    public static MySqlOffsetContext initial(MySqlConnectorConfig config) {
        MySqlOffsetContext offset = new MySqlOffsetContext(config, false, false, new SourceInfo(config));
        offset.getSource().setBinlogStartPoint("", 0L);
        return offset;
    }

    public String toString() {
        return super.toString();
    }

    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.tableEvent((TableId)tableId);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public SourceInfo getSource() {
        return this.sourceInfo;
    }

    public static class Loader
    implements OffsetContext.Loader {
        private final MySqlConnectorConfig connectorConfig;

        public Loader(MySqlConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Map<String, ?> getPartition() {
            return Collections.singletonMap(MySqlOffsetContext.SERVER_PARTITION_KEY, this.connectorConfig.getLogicalName());
        }

        public OffsetContext load(Map<String, ?> offset) {
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(MySqlOffsetContext.SNAPSHOT_COMPLETED_KEY));
            SourceInfo sourceInfo = new SourceInfo(this.connectorConfig);
            MySqlOffsetContext offsetContext = new MySqlOffsetContext(this.connectorConfig, snapshot, snapshotCompleted, TransactionContext.load(offset), sourceInfo);
            sourceInfo.setOffset(offset);
            return offsetContext;
        }
    }
}

