/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.HistorizedDatabaseSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.util.Collect;
import io.debezium.util.SchemaNameAdjuster;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MySqlDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlDatabaseSchema.class);
    private final Set<String> ignoredQueryStatements = Collect.unmodifiableSet((Object[])new String[]{"BEGIN", "END", "FLUSH PRIVILEGES"});
    private final DdlParser ddlParser;
    private final RelationalTableFilters filters;
    private final DdlChanges ddlChanges;

    public MySqlDatabaseSchema(MySqlConnectorConfig connectorConfig, MySqlValueConverters valueConverter, TopicSelector<TableId> topicSelector, SchemaNameAdjuster schemaNameAdjuster, boolean tableIdCaseInsensitive) {
        super((HistorizedRelationalDatabaseConnectorConfig)connectorConfig, topicSelector, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)valueConverter, schemaNameAdjuster, connectorConfig.customConverterRegistry(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getSanitizeFieldNames()), tableIdCaseInsensitive, connectorConfig.getKeyMapper());
        this.ddlParser = new MySqlAntlrDdlParser(valueConverter, this.getTableFilter());
        this.ddlChanges = this.ddlParser.getDdlChanges();
        this.filters = connectorConfig.getTableFilters();
    }

    public String[] monitoredTablesAsStringArray() {
        Set tables = this.tableIds();
        String[] ret = new String[tables.size()];
        int i = 0;
        for (TableId table : tables) {
            ret[i++] = table.toString();
        }
        return ret;
    }

    public void setSystemVariables(Map<String, String> variables) {
        variables.forEach((varName, value) -> this.ddlParser.systemVariables().setVariable((SystemVariables.Scope)MySqlSystemVariables.MySqlScope.SESSION, varName, value));
    }

    public SystemVariables systemVariables() {
        return this.ddlParser.systemVariables();
    }

    protected void appendDropTableStatement(StringBuilder sb, TableId tableId) {
        sb.append("DROP TABLE ").append(tableId).append(" IF EXISTS;").append(System.lineSeparator());
    }

    protected void appendCreateTableStatement(StringBuilder sb, Table table) {
        sb.append("CREATE TABLE ").append(table.id()).append(';').append(System.lineSeparator());
    }

    protected void refreshSchemas() {
        this.clearSchemas();
        this.tableIds().forEach(id -> {
            Table table = this.tableFor((TableId)id);
            this.buildAndRegisterSchema(table);
        });
    }

    public boolean isGlobalSetVariableStatement(String ddl, String databaseName) {
        return (databaseName == null || databaseName.isEmpty()) && ddl != null && ddl.toUpperCase().startsWith("SET ");
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        this.applySchemaChange(schemaChange, HistorizedDatabaseSchema.SchemaChangeEventConsumer.NOOP);
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange, HistorizedDatabaseSchema.SchemaChangeEventConsumer schemaEventConsumer) {
        Set changes;
        block13: {
            String ddlStatements;
            block11: {
                String databaseName;
                block12: {
                    LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
                    if (schemaChange.getType() != SchemaChangeEvent.SchemaChangeEventType.RAW) {
                        LOGGER.debug("Schema change already processed by the database schema");
                        return;
                    }
                    ddlStatements = schemaChange.getDdl();
                    databaseName = schemaChange.getDatabase();
                    if (this.ignoredQueryStatements.contains(ddlStatements)) {
                        return;
                    }
                    try {
                        this.ddlChanges.reset();
                        this.ddlParser.setCurrentSchema(databaseName);
                        this.ddlParser.parse(ddlStatements, this.tables());
                    }
                    catch (MultipleParsingExceptions | ParsingException e) {
                        if (this.databaseHistory.skipUnparseableDdlStatements()) {
                            LOGGER.warn("Ignoring unparseable DDL statement '{}': {}", (Object)ddlStatements, (Object)e);
                        }
                        throw e;
                    }
                    changes = this.tables().drainChanges();
                    if (this.databaseHistory.storeOnlyMonitoredTables() && !this.isGlobalSetVariableStatement(ddlStatements, databaseName) && !this.ddlChanges.anyMatch(this.filters)) break block11;
                    if (schemaEventConsumer != null) {
                        if (!this.ddlChanges.isEmpty()) {
                            this.ddlChanges.getEventsByDatabase((dbName, events) -> {
                                if (this.acceptableDatabase(dbName)) {
                                    String sanitizedDbName = dbName == null ? "" : dbName;
                                    HashSet tableIds = new HashSet();
                                    events.forEach(event -> {
                                        TableId tableId = this.getTableId((DdlParserListener.Event)event);
                                        if (tableId != null) {
                                            tableIds.add(tableId);
                                        }
                                    });
                                    Struct source = schemaChange.getSource();
                                    source.put("db", (Object)sanitizedDbName);
                                    String tableNamesStr = tableIds.stream().map(TableId::table).collect(Collectors.joining(","));
                                    if (!tableNamesStr.isEmpty()) {
                                        source.put("table", (Object)tableNamesStr);
                                    }
                                    schemaEventConsumer.consume(new SchemaChangeEvent(schemaChange.getPartition(), schemaChange.getOffset(), schemaChange.getSource(), sanitizedDbName, schemaChange.getSchema(), schemaChange.getDdl(), Collections.emptySet(), SchemaChangeEvent.SchemaChangeEventType.DATABASE, schemaChange.isFromSnapshot()), tableIds);
                                }
                            });
                        } else if (this.acceptableDatabase(databaseName)) {
                            schemaEventConsumer.consume(schemaChange, null);
                        }
                    }
                    if (!this.databaseHistory.storeOnlyMonitoredTables() || this.isGlobalSetVariableStatement(ddlStatements, databaseName)) break block12;
                    if (!changes.stream().anyMatch(arg_0 -> ((Tables.TableFilter)this.filters.dataCollectionFilter()).isIncluded(arg_0))) break block13;
                }
                LOGGER.debug("Recorded DDL statements for database '{}': {}", (Object)databaseName, (Object)ddlStatements);
                this.record(schemaChange, schemaChange.getTableChanges());
                break block13;
            }
            LOGGER.debug("Changes for DDL '{}' were filtered and not recorded in database history", (Object)ddlStatements);
        }
        TableChanges tableChanges = new TableChanges();
        changes.forEach(tableId -> {
            Table table = this.tableFor((TableId)tableId);
            if (table == null) {
                this.removeSchema((TableId)tableId);
            } else {
                this.buildAndRegisterSchema(table);
                tableChanges.create(table);
            }
        });
    }

    private boolean acceptableDatabase(String databaseName) {
        return this.filters.databaseFilter().test(databaseName) || databaseName == null || databaseName.isEmpty();
    }

    private TableId getTableId(DdlParserListener.Event event) {
        if (event instanceof DdlParserListener.TableEvent) {
            return ((DdlParserListener.TableEvent)event).tableId();
        }
        if (event instanceof DdlParserListener.TableIndexEvent) {
            return ((DdlParserListener.TableIndexEvent)event).tableId();
        }
        return null;
    }

    protected DdlParser getDdlParser() {
        return this.ddlParser;
    }

    public boolean historyExists() {
        return this.databaseHistory.exists();
    }

    public boolean storeOnlyMonitoredTables() {
        return this.databaseHistory.storeOnlyMonitoredTables();
    }
}

