/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlConnectorTask;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnector
extends SourceConnector {
    public static final String IMPLEMENTATION_PROP = "internal.implementation";
    private static final String LEGACY_IMPLEMENTATION = "legacy";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, String> properties;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public Class<? extends Task> taskClass() {
        String implementation = this.properties.get(IMPLEMENTATION_PROP);
        if (MySqlConnector.isLegacy(implementation)) {
            this.logger.warn("Legacy MySQL connector implementation is enabled");
            return io.debezium.connector.mysql.legacy.MySqlConnectorTask.class;
        }
        return MySqlConnectorTask.class;
    }

    static boolean isLegacy(String implementation) {
        return LEGACY_IMPLEMENTATION.equals(implementation);
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return MySqlConnectorConfig.configDef();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map results = config.validate(MySqlConnectorConfig.EXPOSED_FIELDS);
        ConfigValue hostnameValue = (ConfigValue)results.get(MySqlConnectorConfig.HOSTNAME.name());
        ConfigValue portValue = (ConfigValue)results.get(MySqlConnectorConfig.PORT.name());
        ConfigValue userValue = (ConfigValue)results.get(MySqlConnectorConfig.USER.name());
        String passwordValue = config.getString(MySqlConnectorConfig.PASSWORD);
        if (Strings.isNullOrEmpty((String)passwordValue)) {
            this.logger.warn("The connection password is empty");
        }
        if (hostnameValue.errorMessages().isEmpty() && portValue.errorMessages().isEmpty() && userValue.errorMessages().isEmpty()) {
            MySqlConnection.MySqlConnectionConfiguration connectionConfig = new MySqlConnection.MySqlConnectionConfiguration(config);
            try (MySqlConnection connection = new MySqlConnection(connectionConfig);){
                try {
                    connection.connect();
                    connection.execute(new String[]{"SELECT version()"});
                    this.logger.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connectionConfig.username());
                }
                catch (SQLException e) {
                    this.logger.info("Failed testing connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connectionConfig.username());
                    hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
                }
            }
            catch (SQLException e) {
                this.logger.error("Unexpected error shutting down the database connection", (Throwable)e);
            }
        }
        return new Config(new ArrayList(results.values()));
    }
}

