/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.source.SourceRecord;

public class MySqlChangeRecordEmitter
implements ChangeRecordEmitter {
    private final Envelope.Operation operation;
    private final SourceRecord record;
    private final OffsetContext offset;

    public MySqlChangeRecordEmitter(OffsetContext offset, Envelope.Operation operation, SourceRecord record) {
        this.offset = offset;
        this.operation = operation;
        this.record = record;
    }

    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver receiver) throws InterruptedException {
        final Struct value = (Struct)this.record.value();
        if (value == null) {
            return;
        }
        String op = value.getString("op");
        receiver.changeRecord(schema, Envelope.Operation.forCode((String)op), this.record.key(), value, new OffsetContext(){

            public Map<String, ?> getPartition() {
                return MySqlChangeRecordEmitter.this.record.sourcePartition();
            }

            public Map<String, ?> getOffset() {
                return MySqlChangeRecordEmitter.this.record.sourceOffset();
            }

            public Schema getSourceInfoSchema() {
                return value.getStruct("source").schema();
            }

            public Struct getSourceInfo() {
                return value.getStruct("source");
            }

            public boolean isSnapshotRunning() {
                return false;
            }

            public void markLastSnapshotRecord() {
            }

            public void preSnapshotStart() {
            }

            public void preSnapshotCompletion() {
            }

            public void postSnapshotCompletion() {
            }

            public void event(DataCollectionId collectionId, Instant timestamp) {
            }

            public TransactionContext getTransactionContext() {
                return null;
            }
        }, (ConnectHeaders)this.record.headers());
    }

    public OffsetContext getOffset() {
        return this.offset;
    }
}

