/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySQLConnection;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlSchemaMigrationIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-json.txt").toAbsolutePath();
    private UniqueDatabase DATABASE = new UniqueDatabase("migration", "empty").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void shouldCorrectlyMigrateTable() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("monitored") + "," + this.DATABASE.qualifiedTableName("_monitored_new"))).build();
        MySQLConnection connection = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection.execute(new String[]{"create table monitored (id int auto_increment primary key, value1 varchar(100), value2 int)"});
        connection.execute(new String[]{"insert into monitored values(default, 'a1', 1)"});
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        connection.execute(new String[]{"insert into monitored values(default, 'a2', 2)"});
        connection.execute(new String[]{"CREATE TABLE `_monitored_new` ( `id` int(11) NOT NULL AUTO_INCREMENT, `value1` varchar(100) DEFAULT NULL, `value2` int(11) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1"});
        connection.execute(new String[]{"ALTER TABLE `_monitored_new` drop value1"});
        connection.execute(new String[]{"insert into _monitored_new values(default, 1)"});
        connection.execute(new String[]{"insert into _monitored_new values(default, 2)"});
        connection.execute(new String[]{"RENAME TABLE `monitored` TO `_monitored_old`, `_monitored_new` TO `monitored`"});
        connection.execute(new String[]{"insert into monitored values(default, 3)"});
        records = this.consumeRecordsByTopic(4);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(arg_0 -> ((MySqlSchemaMigrationIT)this).validate(arg_0));
        this.assertInsert((SourceRecord)records.allRecordsInOrder().get(3), "id", 5);
    }

    @Test
    public void shouldProcessAndWarnOnNonWhitelistedMigrateTable() throws SQLException, InterruptedException {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("monitored"))).build();
        MySQLConnection connection = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection.execute(new String[]{"create table monitored (id int auto_increment primary key, value1 varchar(100), value2 int)"});
        connection.execute(new String[]{"insert into monitored values(default, 'a1', 1)"});
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        connection.execute(new String[]{"insert into monitored values(default, 'a2', 2)"});
        connection.execute(new String[]{"CREATE TABLE `_monitored_new` ( `id` int(11) NOT NULL AUTO_INCREMENT, `value1` varchar(100) DEFAULT NULL, `value2` int(11) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1"});
        connection.execute(new String[]{"ALTER TABLE `_monitored_new` drop value1"});
        connection.execute(new String[]{"insert into _monitored_new values(default, 1)"});
        connection.execute(new String[]{"insert into _monitored_new values(default, 2)"});
        connection.execute(new String[]{"RENAME TABLE `monitored` TO `_monitored_old`, `_monitored_new` TO `monitored`"});
        connection.execute(new String[]{"insert into monitored values(default, 3)"});
        String msg1 = "Renaming whitelisted table " + this.DATABASE.qualifiedTableName("monitored") + " to non-whitelisted table " + this.DATABASE.qualifiedTableName("_monitored_old") + ", this can lead to schema inconsistency";
        String msg2 = "Renaming non-whitelisted table " + this.DATABASE.qualifiedTableName("_monitored_new") + " to whitelisted table " + this.DATABASE.qualifiedTableName("monitored") + ", this can lead to schema inconsistency";
        records = this.consumeRecordsByTopic(2);
        this.stopConnector(value -> {
            Assertions.assertThat((boolean)logInterceptor.containsWarnMessage(msg1)).isTrue();
            Assertions.assertThat((boolean)logInterceptor.containsWarnMessage(msg2)).isTrue();
        });
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(arg_0 -> ((MySqlSchemaMigrationIT)this).validate(arg_0));
        this.assertInsert((SourceRecord)records.allRecordsInOrder().get(1), "id", 5);
    }

    @Test
    public void shouldWarnOnInvalidMigrateTable() throws SQLException, InterruptedException {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, true)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("monitored"))).build();
        MySQLConnection connection = MySQLConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        connection.execute(new String[]{"create table monitored (id int auto_increment primary key, value1 varchar(100), value2 int)"});
        connection.execute(new String[]{"insert into monitored values(default, 'a1', 1)"});
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        connection.execute(new String[]{"insert into monitored values(default, 'a2', 2)"});
        connection.execute(new String[]{"CREATE TABLE `_monitored_new` ( `id` int(11) NOT NULL AUTO_INCREMENT, `value1` varchar(100) DEFAULT NULL, `value2` int(11) DEFAULT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1"});
        connection.execute(new String[]{"ALTER TABLE `_monitored_new` drop value1"});
        connection.execute(new String[]{"insert into _monitored_new values(default, 1)"});
        connection.execute(new String[]{"insert into _monitored_new values(default, 2)"});
        connection.execute(new String[]{"RENAME TABLE `monitored` TO `_monitored_old`, `_monitored_new` TO `monitored`"});
        connection.execute(new String[]{"insert into monitored values(default, 3)"});
        String msg1 = "Renaming whitelisted table " + this.DATABASE.qualifiedTableName("monitored") + " to non-whitelisted table " + this.DATABASE.qualifiedTableName("_monitored_old") + ", this can lead to schema inconsistency";
        String msg2 = "Renaming non-whitelisted table " + this.DATABASE.qualifiedTableName("_monitored_new") + " to whitelisted table " + this.DATABASE.qualifiedTableName("monitored") + ", this can lead to schema inconsistency";
        records = this.consumeRecordsByTopic(2);
        this.stopConnector(value -> {
            Assertions.assertThat((boolean)logInterceptor.containsWarnMessage(msg1)).isTrue();
            Assertions.assertThat((boolean)logInterceptor.containsWarnMessage(msg2)).isTrue();
        });
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(arg_0 -> ((MySqlSchemaMigrationIT)this).validate(arg_0));
        this.assertInsert((SourceRecord)records.allRecordsInOrder().get(1), "id", 5);
    }
}

