/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;

class Configurator {
    private final Configuration.Builder configBuilder = Configuration.create();

    Configurator() {
    }

    Configurator with(Field field, String value) {
        this.configBuilder.with(field, value);
        return this;
    }

    Configurator with(Field field, boolean value) {
        this.configBuilder.with(field, value);
        return this;
    }

    Configurator serverName(String serverName) {
        return this.with(MySqlConnectorConfig.SERVER_NAME, serverName);
    }

    Configurator includeDatabases(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MySqlConnectorConfig.DATABASE_WHITELIST.name() + "\" config property"));
            return this.with(MySqlConnectorConfig.DATABASE_WHITELIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MySqlConnectorConfig.DATABASE_INCLUDE_LIST.name() + "\" config property"));
        return this.with(MySqlConnectorConfig.DATABASE_INCLUDE_LIST, regexList);
    }

    Configurator excludeDatabases(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MySqlConnectorConfig.DATABASE_BLACKLIST.name() + "\" config property"));
            return this.with(MySqlConnectorConfig.DATABASE_BLACKLIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MySqlConnectorConfig.DATABASE_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MySqlConnectorConfig.DATABASE_EXCLUDE_LIST, regexList);
    }

    Configurator includeTables(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MySqlConnectorConfig.TABLE_WHITELIST.name() + "\" config property"));
            return this.with(MySqlConnectorConfig.TABLE_WHITELIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MySqlConnectorConfig.TABLE_INCLUDE_LIST.name() + "\" config property"));
        return this.with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, regexList);
    }

    Configurator excludeTables(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MySqlConnectorConfig.TABLE_BLACKLIST.name() + "\" config property"));
            return this.with(MySqlConnectorConfig.TABLE_BLACKLIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MySqlConnectorConfig.TABLE_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MySqlConnectorConfig.TABLE_EXCLUDE_LIST, regexList);
    }

    Configurator includeColumns(String regexList) {
        return this.with(MySqlConnectorConfig.COLUMN_INCLUDE_LIST, regexList);
    }

    Configurator excludeColumns(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MySqlConnectorConfig.COLUMN_BLACKLIST.name() + "\" config property"));
            return this.with(MySqlConnectorConfig.COLUMN_BLACKLIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MySqlConnectorConfig.COLUMN_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MySqlConnectorConfig.COLUMN_EXCLUDE_LIST, regexList);
    }

    Configurator truncateColumns(int length, String fullyQualifiedTableNames) {
        if (length <= 0) {
            throw new IllegalArgumentException("The truncation length must be positive");
        }
        return this.with(Field.create((String)("column.truncate.to." + length + ".chars")).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("A comma-separated list of regular expressions matching fully-qualified names of columns that should be truncated to " + length + " characters."), fullyQualifiedTableNames);
    }

    Configurator maskColumns(int length, String fullyQualifiedTableNames) {
        if (length <= 0) {
            throw new IllegalArgumentException("The mask length must be positive");
        }
        return this.with(Field.create((String)("column.mask.with." + length + ".chars")).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("A comma-separated list of regular expressions matching fully-qualified names of columns that should be masked with " + length + " asterisk ('*') characters."), fullyQualifiedTableNames);
    }

    Configurator excludeBuiltInTables() {
        return this.with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, true);
    }

    Configurator includeBuiltInTables() {
        return this.with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, false);
    }

    Configurator storeDatabaseHistoryInFile(Path path) {
        this.with(MySqlConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class.getName());
        this.with(FileDatabaseHistory.FILE_PATH, path.toAbsolutePath().toString());
        return this;
    }

    Filters createFilters() {
        return new Filters.Builder(this.configBuilder.build()).build();
    }

    MySqlSchema createSchemas() {
        return this.createSchemasWithFilter(this.createFilters());
    }

    MySqlSchema createSchemasWithFilter(Filters filters) {
        Configuration config = this.configBuilder.build();
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(config);
        return new MySqlSchema(connectorConfig, null, false, MySqlTopicSelector.defaultSelector((String)connectorConfig.getLogicalName(), (String)"__debezium-heartbeat"), filters);
    }
}

