/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MysqlDefaultValueAllZeroTimeIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "default_value_all_zero_time").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize(Collections.singletonMap("sessionVariables", "sql_mode=''"));
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    public void allZeroDateAndTimeTypeTest() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_WHITELIST, this.DATABASE.qualifiedTableName("ALL_ZERO_DATE_AND_TIME_TABLE"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("ALL_ZERO_DATE_AND_TIME_TABLE")).get(0);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Schema schemaI = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(8)).schema();
        Schema schemaJ = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(9)).schema();
        Schema schemaK = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(10)).schema();
        Schema schemaL = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(11)).schema();
        ZonedDateTime a = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        String isoStringA = ZonedTimestamp.toIsoString((Object)a, (ZoneId)ZoneOffset.UTC, MySqlValueConverters::adjustTemporal);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)isoStringA);
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo(null);
        ZonedDateTime c = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        String isoStringC = ZonedTimestamp.toIsoString((Object)c, (ZoneId)ZoneOffset.UTC, MySqlValueConverters::adjustTemporal);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)isoStringC);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaH.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo(null);
        String valueI = "1970-01-01 00:00:00";
        long toEpochMillisI = Timestamp.toEpochMillis((Object)LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse(valueI)), MySqlValueConverters::adjustTemporal);
        Assertions.assertThat((Object)schemaI.defaultValue()).isEqualTo((Object)toEpochMillisI);
        Assertions.assertThat((boolean)schemaJ.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaJ.defaultValue()).isEqualTo(null);
        String valueK = "1970-01-01 00:00:00";
        long toEpochMillisK = Timestamp.toEpochMillis((Object)LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse(valueK)), MySqlValueConverters::adjustTemporal);
        Assertions.assertThat((Object)schemaK.defaultValue()).isEqualTo((Object)toEpochMillisK);
        Assertions.assertThat((boolean)schemaL.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaL.defaultValue()).isEqualTo(null);
    }
}

