/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.DatabaseDifferences;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import java.util.Map;

public class MySQLConnection
extends JdbcConnection {
    private DatabaseDifferences databaseAsserts;
    private MySqlVersion mySqlVersion;
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}/${dbname}", (Field[])new Field[0]);

    public static MySQLConnection forTestDatabase(String databaseName) {
        return new MySQLConnection(((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDatabase(databaseName).with("useSSL", false)).with("characterEncoding", "utf8")).build());
    }

    public static MySQLConnection forTestDatabase(String databaseName, Map<String, Object> urlProperties) {
        JdbcConfiguration.Builder builder = (JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDatabase(databaseName).with("useSSL", false)).with("characterEncoding", "utf8");
        urlProperties.forEach((arg_0, arg_1) -> ((JdbcConfiguration.Builder)builder).with(arg_0, arg_1));
        return new MySQLConnection(builder.build());
    }

    public static MySQLConnection forTestDatabase(String databaseName, String username, String password) {
        return new MySQLConnection(((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDatabase(databaseName).withUser(username).withPassword(password).with("useSSL", false)).build());
    }

    public static boolean isMySQL5() {
        switch (MySQLConnection.forTestDatabase("mysql").getMySqlVersion()) {
            case MYSQL_5_5: 
            case MYSQL_5_6: 
            case MYSQL_5_7: {
                return true;
            }
        }
        return false;
    }

    protected static void addDefaults(Configuration.Builder builder) {
        ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 3306)).withDefault(JdbcConfiguration.USER, "mysqluser")).withDefault(JdbcConfiguration.PASSWORD, "mysqlpw");
    }

    public MySQLConnection(Configuration config) {
        super(config, FACTORY, null, MySQLConnection::addDefaults);
    }

    public MySqlVersion getMySqlVersion() {
        if (this.mySqlVersion == null) {
            String versionString = this.getMySqlVersionString();
            if (versionString.startsWith("8.")) {
                this.mySqlVersion = MySqlVersion.MYSQL_8;
            } else if (versionString.startsWith("5.5")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_5;
            } else if (versionString.startsWith("5.6")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_6;
            } else if (versionString.startsWith("5.7")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_7;
            } else {
                throw new IllegalStateException("Couldn't resolve MySQL Server version");
            }
        }
        return this.mySqlVersion;
    }

    public String getMySqlVersionString() {
        String versionString;
        try {
            versionString = (String)this.connect().queryAndMap("SHOW GLOBAL VARIABLES LIKE 'version'", rs -> {
                rs.next();
                return rs.getString(2);
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't obtain MySQL Server version", e);
        }
        return versionString;
    }

    public DatabaseDifferences databaseAsserts() {
        if (this.databaseAsserts == null) {
            this.databaseAsserts = this.getMySqlVersion() == MySqlVersion.MYSQL_8 ? new DatabaseDifferences(){

                @Override
                public boolean isCurrentDateTimeDefaultGenerated() {
                    return true;
                }

                @Override
                public String currentDateTimeDefaultOptional(String isoString) {
                    return null;
                }
            } : new DatabaseDifferences(){

                @Override
                public boolean isCurrentDateTimeDefaultGenerated() {
                    return false;
                }

                @Override
                public String currentDateTimeDefaultOptional(String isoString) {
                    return isoString;
                }
            };
        }
        return this.databaseAsserts;
    }

    public static enum MySqlVersion {
        MYSQL_5_5,
        MYSQL_5_6,
        MYSQL_5_7,
        MYSQL_8;

    }
}

