/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.document.Document;
import io.debezium.relational.TableId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;

@NotThreadSafe
final class SourceInfo
extends AbstractSourceInfo {
    public static final String SERVER_ID_KEY = "server_id";
    public static final String SERVER_PARTITION_KEY = "server";
    public static final String GTID_SET_KEY = "gtids";
    public static final String GTID_KEY = "gtid";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String BINLOG_FILENAME_OFFSET_KEY = "file";
    public static final String BINLOG_POSITION_OFFSET_KEY = "pos";
    public static final String BINLOG_ROW_IN_EVENT_OFFSET_KEY = "row";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String THREAD_KEY = "thread";
    public static final String QUERY_KEY = "query";
    public static final String DATABASE_WHITELIST_KEY = "database_whitelist";
    public static final String DATABASE_BLACKLIST_KEY = "database_blacklist";
    public static final String TABLE_WHITELIST_KEY = "table_whitelist";
    public static final String TABLE_BLACKLIST_KEY = "table_blacklist";
    public static final String RESTART_PREFIX = "RESTART_";
    private String currentGtidSet;
    private String currentGtid;
    private String currentBinlogFilename;
    private long currentBinlogPosition = 0L;
    private int currentRowNumber = 0;
    private long currentEventLengthInBytes = 0L;
    private String restartGtidSet;
    private String restartBinlogFilename;
    private long restartBinlogPosition = 0L;
    private long restartEventsToSkip = 0L;
    private int restartRowsToSkip = 0;
    private boolean inTransaction = false;
    private long serverId = 0L;
    private long binlogTimestampSeconds = 0L;
    private long threadId = -1L;
    private final Map<String, String> sourcePartition;
    private boolean lastSnapshot = true;
    private boolean nextSnapshot = false;
    private String currentQuery = null;
    private String databaseWhitelist;
    private String databaseBlacklist;
    private String tableWhitelist;
    private String tableBlacklist;
    private Set<TableId> tableIds;
    private String databaseName;

    public SourceInfo(MySqlConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
        this.sourcePartition = Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)connectorConfig.getLogicalName());
        this.tableIds = new HashSet<TableId>();
    }

    public void setQuery(String query) {
        this.currentQuery = query;
    }

    public String getQuery() {
        return this.currentQuery;
    }

    public Map<String, String> partition() {
        return this.sourcePartition;
    }

    public void setBinlogStartPoint(String binlogFilename, long positionOfFirstEvent) {
        if (binlogFilename != null) {
            this.currentBinlogFilename = binlogFilename;
            this.restartBinlogFilename = binlogFilename;
        }
        assert (positionOfFirstEvent >= 0L);
        this.currentBinlogPosition = positionOfFirstEvent;
        this.restartBinlogPosition = positionOfFirstEvent;
        this.currentRowNumber = 0;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
    }

    public void setEventPosition(long positionOfCurrentEvent, long eventSizeInBytes) {
        this.currentBinlogPosition = positionOfCurrentEvent;
        this.currentEventLengthInBytes = eventSizeInBytes;
        if (!this.inTransaction) {
            this.restartBinlogPosition = positionOfCurrentEvent + eventSizeInBytes;
            this.restartRowsToSkip = 0;
            this.restartEventsToSkip = 0L;
        }
    }

    public Map<String, ?> offset() {
        return this.offsetUsingPosition(this.restartRowsToSkip);
    }

    public Map<String, Object> offsetForRow(int eventRowNumber, int totalNumberOfRows) {
        if (eventRowNumber < totalNumberOfRows - 1) {
            this.currentRowNumber = eventRowNumber;
            this.restartRowsToSkip = this.currentRowNumber + 1;
            return this.offsetUsingPosition(this.restartRowsToSkip);
        }
        this.currentRowNumber = eventRowNumber;
        this.restartRowsToSkip = 0;
        return this.offsetUsingPosition(totalNumberOfRows);
    }

    private Map<String, Object> offsetUsingPosition(long rowsToSkip) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.serverId != 0L) {
            map.put(SERVER_ID_KEY, this.serverId);
        }
        if (this.restartGtidSet != null) {
            map.put(GTID_SET_KEY, this.restartGtidSet);
        }
        map.put(BINLOG_FILENAME_OFFSET_KEY, this.restartBinlogFilename);
        map.put(BINLOG_POSITION_OFFSET_KEY, this.restartBinlogPosition);
        if (this.restartEventsToSkip != 0L) {
            map.put(EVENTS_TO_SKIP_OFFSET_KEY, this.restartEventsToSkip);
        }
        if (rowsToSkip != 0L) {
            map.put(BINLOG_ROW_IN_EVENT_OFFSET_KEY, rowsToSkip);
        }
        if (this.binlogTimestampSeconds != 0L) {
            map.put(TIMESTAMP_KEY, this.binlogTimestampSeconds);
        }
        if (this.isSnapshotInEffect()) {
            map.put("snapshot", true);
        }
        if (this.hasFilterInfo()) {
            map.put(DATABASE_WHITELIST_KEY, this.databaseWhitelist);
            map.put(DATABASE_BLACKLIST_KEY, this.databaseBlacklist);
            map.put(TABLE_WHITELIST_KEY, this.tableWhitelist);
            map.put(TABLE_BLACKLIST_KEY, this.tableBlacklist);
        }
        return map;
    }

    public void databaseEvent(String databaseName) {
        this.databaseName = databaseName;
    }

    public void tableEvent(Set<TableId> tableIds) {
        this.tableIds = new HashSet<TableId>(tableIds);
    }

    public void tableEvent(TableId tableId) {
        this.tableIds = Collections.singleton(tableId);
    }

    public boolean isSnapshotInEffect() {
        return this.nextSnapshot;
    }

    public void startNextTransaction() {
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.restartBinlogFilename = this.currentBinlogFilename;
        this.restartBinlogPosition = this.currentBinlogPosition;
        this.inTransaction = true;
    }

    public void completeEvent() {
        ++this.restartEventsToSkip;
    }

    public long eventsToSkipUponRestart() {
        return this.restartEventsToSkip;
    }

    public void commitTransaction() {
        this.restartGtidSet = this.currentGtidSet;
        this.restartBinlogFilename = this.currentBinlogFilename;
        this.restartBinlogPosition = this.currentBinlogPosition + this.currentEventLengthInBytes;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.inTransaction = false;
        this.currentQuery = null;
    }

    public void startGtid(String gtid, String gtidSet) {
        this.currentGtid = gtid;
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = this.currentGtidSet != null ? this.currentGtidSet : trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet;
        }
    }

    public void setCompletedGtidSet(String gtidSet) {
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = trimmedGtidSet;
        }
    }

    public void setBinlogServerId(long serverId) {
        this.serverId = serverId;
    }

    public void setBinlogTimestampSeconds(long timestampInSeconds) {
        this.binlogTimestampSeconds = timestampInSeconds;
    }

    public void setBinlogThread(long threadId) {
        this.threadId = threadId;
    }

    public void startSnapshot() {
        this.lastSnapshot = true;
        this.nextSnapshot = true;
    }

    public void markLastSnapshot(Configuration config) {
        this.lastSnapshot = true;
        this.nextSnapshot = false;
        this.maybeSetFilterDataFromConfig(config);
    }

    public void completeSnapshot() {
        this.lastSnapshot = false;
        this.nextSnapshot = false;
    }

    public void setFilterDataFromConfig(Configuration config) {
        this.databaseWhitelist = config.getString(MySqlConnectorConfig.DATABASE_WHITELIST);
        this.databaseBlacklist = config.getString(MySqlConnectorConfig.DATABASE_BLACKLIST);
        this.tableWhitelist = config.getString(MySqlConnectorConfig.TABLE_WHITELIST);
        this.tableBlacklist = config.getString(MySqlConnectorConfig.TABLE_BLACKLIST);
    }

    public void maybeSetFilterDataFromConfig(Configuration config) {
        if (config.getString(MySqlConnectorConfig.SNAPSHOT_NEW_TABLES).equals(MySqlConnectorConfig.SnapshotNewTables.PARALLEL.getValue())) {
            this.setFilterDataFromConfig(config);
        }
    }

    public boolean hasFilterInfo() {
        return this.databaseWhitelist != null || this.databaseBlacklist != null || this.tableWhitelist != null || this.tableBlacklist != null;
    }

    public String getDatabaseWhitelist() {
        return this.databaseWhitelist;
    }

    public String getDatabaseBlacklist() {
        return this.databaseBlacklist;
    }

    public String getTableWhitelist() {
        return this.tableWhitelist;
    }

    public String getTableBlacklist() {
        return this.tableBlacklist;
    }

    public void setOffset(Map<String, ?> sourceOffset) {
        if (sourceOffset != null) {
            this.setCompletedGtidSet((String)sourceOffset.get(GTID_SET_KEY));
            String binlogFilename = (String)sourceOffset.get(BINLOG_FILENAME_OFFSET_KEY);
            if (binlogFilename == null) {
                throw new ConnectException("Source offset 'file' parameter is missing");
            }
            long binlogPosition = this.longOffsetValue(sourceOffset, BINLOG_POSITION_OFFSET_KEY);
            this.setBinlogStartPoint(binlogFilename, binlogPosition);
            this.restartRowsToSkip = (int)this.longOffsetValue(sourceOffset, BINLOG_ROW_IN_EVENT_OFFSET_KEY);
            this.restartEventsToSkip = this.longOffsetValue(sourceOffset, EVENTS_TO_SKIP_OFFSET_KEY);
            this.lastSnapshot = this.nextSnapshot = this.booleanOffsetValue(sourceOffset, "snapshot");
            this.databaseWhitelist = (String)sourceOffset.get(DATABASE_WHITELIST_KEY);
            this.databaseBlacklist = (String)sourceOffset.get(DATABASE_BLACKLIST_KEY);
            this.tableWhitelist = (String)sourceOffset.get(TABLE_WHITELIST_KEY);
            this.tableBlacklist = (String)sourceOffset.get(TABLE_BLACKLIST_KEY);
        }
    }

    public static boolean offsetsHaveFilterInfo(Map<String, ?> sourceOffset) {
        return sourceOffset != null && sourceOffset.containsKey(DATABASE_BLACKLIST_KEY) || sourceOffset.containsKey(DATABASE_WHITELIST_KEY) || sourceOffset.containsKey(TABLE_BLACKLIST_KEY) || sourceOffset.containsKey(TABLE_WHITELIST_KEY);
    }

    private long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    private boolean booleanOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    public String gtidSet() {
        return this.currentGtidSet != null ? this.currentGtidSet : null;
    }

    public String binlogFilename() {
        return this.restartBinlogFilename;
    }

    public long binlogPosition() {
        return this.restartBinlogPosition;
    }

    protected long restartBinlogPosition() {
        return this.restartBinlogPosition;
    }

    public int rowsToSkipUponRestart() {
        return this.restartRowsToSkip;
    }

    long getServerId() {
        return this.serverId;
    }

    long getThreadId() {
        return this.threadId;
    }

    String table() {
        return this.tableIds.isEmpty() ? null : this.tableIds.stream().map(TableId::table).collect(Collectors.joining(","));
    }

    String getCurrentGtid() {
        return this.currentGtid;
    }

    boolean isLastSnapshot() {
        return this.lastSnapshot;
    }

    String getCurrentBinlogFilename() {
        return this.currentBinlogFilename;
    }

    long getCurrentBinlogPosition() {
        return this.currentBinlogPosition;
    }

    long getBinlogTimestampSeconds() {
        return this.binlogTimestampSeconds;
    }

    int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.currentGtidSet != null) {
            sb.append("GTIDs ");
            sb.append(this.currentGtidSet);
            sb.append(" and binlog file '").append(this.restartBinlogFilename).append("'");
            sb.append(", pos=").append(this.restartBinlogPosition);
            sb.append(", skipping ").append(this.restartEventsToSkip);
            sb.append(" events plus ").append(this.restartRowsToSkip);
            sb.append(" rows");
        } else if (this.restartBinlogFilename == null) {
            sb.append("<latest>");
        } else if ("".equals(this.restartBinlogFilename)) {
            sb.append("earliest binlog file and position");
        } else {
            sb.append("binlog file '").append(this.restartBinlogFilename).append("'");
            sb.append(", pos=").append(this.restartBinlogPosition);
            sb.append(", skipping ").append(this.restartEventsToSkip);
            sb.append(" events plus ").append(this.restartRowsToSkip);
            sb.append(" rows");
        }
        return sb.toString();
    }

    public static Document createDocumentFromOffset(Map<String, ?> offset) {
        Document offsetDocument = Document.create();
        for (Map.Entry<String, ?> entry : offset.entrySet()) {
            offsetDocument.set((CharSequence)entry.getKey(), entry.getValue());
        }
        return offsetDocument;
    }

    public static boolean isPositionAtOrBefore(Document recorded, Document desired, Predicate<String> gtidFilter) {
        int desiredRow;
        int desiredEventCount;
        int desiredPosition;
        int desiredServerId;
        String recordedGtidSetStr = recorded.getString((CharSequence)GTID_SET_KEY);
        String desiredGtidSetStr = desired.getString((CharSequence)GTID_SET_KEY);
        if (desiredGtidSetStr != null) {
            if (recordedGtidSetStr != null) {
                GtidSet recordedGtidSet = new GtidSet(recordedGtidSetStr);
                GtidSet desiredGtidSet = new GtidSet(desiredGtidSetStr);
                if (gtidFilter != null) {
                    recordedGtidSet = recordedGtidSet.retainAll(gtidFilter);
                    desiredGtidSet = desiredGtidSet.retainAll(gtidFilter);
                }
                if (recordedGtidSet.equals(desiredGtidSet)) {
                    int desiredEventCount2;
                    if (!recorded.has((CharSequence)"snapshot") && desired.has((CharSequence)"snapshot")) {
                        return false;
                    }
                    int recordedEventCount = recorded.getInteger((CharSequence)EVENTS_TO_SKIP_OFFSET_KEY, 0);
                    int diff = recordedEventCount - (desiredEventCount2 = desired.getInteger((CharSequence)EVENTS_TO_SKIP_OFFSET_KEY, 0));
                    return diff <= 0;
                }
                return recordedGtidSet.isContainedWithin(desiredGtidSet);
            }
            return true;
        }
        if (recordedGtidSetStr != null) {
            return false;
        }
        int recordedServerId = recorded.getInteger((CharSequence)SERVER_ID_KEY, 0);
        if (recordedServerId != (desiredServerId = recorded.getInteger((CharSequence)SERVER_ID_KEY, 0))) {
            long desiredTimestamp;
            long recordedTimestamp = recorded.getLong((CharSequence)TIMESTAMP_KEY, 0L);
            return recordedTimestamp <= (desiredTimestamp = recorded.getLong((CharSequence)TIMESTAMP_KEY, 0L));
        }
        String recordedFilename = recorded.getString((CharSequence)BINLOG_FILENAME_OFFSET_KEY);
        String desiredFilename = desired.getString((CharSequence)BINLOG_FILENAME_OFFSET_KEY);
        assert (recordedFilename != null);
        int diff = recordedFilename.compareToIgnoreCase(desiredFilename);
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedPosition = recorded.getInteger((CharSequence)BINLOG_POSITION_OFFSET_KEY, -1);
        diff = recordedPosition - (desiredPosition = desired.getInteger((CharSequence)BINLOG_POSITION_OFFSET_KEY, -1));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedEventCount = recorded.getInteger((CharSequence)EVENTS_TO_SKIP_OFFSET_KEY, 0);
        diff = recordedEventCount - (desiredEventCount = desired.getInteger((CharSequence)EVENTS_TO_SKIP_OFFSET_KEY, 0));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedRow = recorded.getInteger((CharSequence)BINLOG_ROW_IN_EVENT_OFFSET_KEY, -1);
        diff = recordedRow - (desiredRow = desired.getInteger((CharSequence)BINLOG_ROW_IN_EVENT_OFFSET_KEY, -1));
        return diff <= 0;
    }

    protected Instant timestamp() {
        return Instant.ofEpochSecond(this.getBinlogTimestampSeconds());
    }

    protected SnapshotRecord snapshot() {
        if (this.isSnapshotInEffect()) {
            return SnapshotRecord.TRUE;
        }
        return SnapshotRecord.FALSE;
    }

    protected String database() {
        return this.tableIds.isEmpty() ? this.databaseName : this.tableIds.iterator().next().catalog();
    }
}

