/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.GtidSet;
import io.debezium.util.Collect;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class GtidSetTest {
    private static final String UUID1 = "24bc7850-2c16-11e6-a073-0242ac110002";
    private GtidSet gtids;

    @Test
    public void shouldCreateSetWithSingleInterval() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191");
        this.asertIntervalCount(UUID1, 1);
        this.asertIntervalExists(UUID1, 1, 191);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertLastInterval(UUID1, 1, 191);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191");
    }

    @Test
    public void shouldCollapseAdjacentIntervals() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:192-199");
        this.asertIntervalCount(UUID1, 1);
        this.asertIntervalExists(UUID1, 1, 199);
        this.asertFirstInterval(UUID1, 1, 199);
        this.asertLastInterval(UUID1, 1, 199);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-199");
    }

    @Test
    public void shouldNotCollapseNonAdjacentIntervals() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199");
        this.asertIntervalCount(UUID1, 2);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertLastInterval(UUID1, 193, 199);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199");
    }

    @Test
    public void shouldCreateWithMultipleIntervals() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199:1000-1033");
        this.asertIntervalCount(UUID1, 3);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertIntervalExists(UUID1, 193, 199);
        this.asertLastInterval(UUID1, 1000, 1033);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199:1000-1033");
    }

    @Test
    public void shouldCreateWithMultipleIntervalsThatMayBeAdjacent() {
        this.gtids = new GtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:192-199:1000-1033:1035-1036:1038-1039");
        this.asertIntervalCount(UUID1, 4);
        this.asertFirstInterval(UUID1, 1, 199);
        this.asertIntervalExists(UUID1, 1000, 1033);
        this.asertIntervalExists(UUID1, 1035, 1036);
        this.asertLastInterval(UUID1, 1038, 1039);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-199:1000-1033:1035-1036:1038-1039");
    }

    @Test
    public void shouldCorrectlyDetermineIfSimpleGtidSetIsContainedWithinAnother() {
        this.gtids = new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41"))).isTrue();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-42"))).isTrue();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:2-41"))).isFalse();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin(new GtidSet("7145bf69-d1ca-11e5-a588-0242ac110004:1"))).isFalse();
    }

    @Test
    public void shouldCorrectlyDetermineIfComplexGtidSetIsContainedWithinAnother() {
        GtidSet connector = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        GtidSet server = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3202,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Assertions.assertThat((boolean)connector.isContainedWithin(server)).isTrue();
    }

    @Test
    public void shouldCorrectlyDetermineIfComplexGtidSetWithVariousLineSeparatorsIsContainedWithinAnother() {
        GtidSet connector = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Arrays.stream(new String[]{"\r\n", "\n", "\r"}).forEach(separator -> {
            GtidSet server = new GtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2," + separator + "7145bf69-d1ca-11e5-a588-0242ac110004:1-3202," + separator + "7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
            Assertions.assertThat((boolean)connector.isContainedWithin(server)).isTrue();
        });
    }

    @Test
    public void shouldFilterServerUuids() {
        String gtidStr = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41";
        List keepers = Collect.arrayListOf((Object)"036d85a9-64e5-11e6-9b48-42010af0000c", (Object[])new String[]{"7c1de3f2-3fd2-11e6-9cdc-42010af000bc", "wont-be-found"});
        GtidSet original = new GtidSet(gtidStr);
        Assertions.assertThat((Object)original.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNotNull();
        GtidSet filtered = original.retainAll(keepers::contains);
        List actualUuids = filtered.getUUIDSets().stream().map(GtidSet.UUIDSet::getUUID).collect(Collectors.toList());
        Assertions.assertThat((boolean)keepers.containsAll(actualUuids)).isTrue();
        Assertions.assertThat((Object)filtered.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNull();
    }

    protected void asertIntervalCount(String uuid, int count) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        Assertions.assertThat((int)set.getIntervals().size()).isEqualTo(count);
    }

    protected void asertIntervalExists(String uuid, int start, int end) {
        Assertions.assertThat((boolean)this.hasInterval(uuid, start, end)).isTrue();
    }

    protected void asertFirstInterval(String uuid, int start, int end) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        GtidSet.Interval interval = (GtidSet.Interval)set.getIntervals().iterator().next();
        Assertions.assertThat((long)interval.getStart()).isEqualTo((long)start);
        Assertions.assertThat((long)interval.getEnd()).isEqualTo((long)end);
    }

    protected void asertLastInterval(String uuid, int start, int end) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        GtidSet.Interval interval = (GtidSet.Interval)new LinkedList(set.getIntervals()).getLast();
        Assertions.assertThat((long)interval.getStart()).isEqualTo((long)start);
        Assertions.assertThat((long)interval.getEnd()).isEqualTo((long)end);
    }

    protected boolean hasInterval(String uuid, int start, int end) {
        GtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        for (GtidSet.Interval interval : set.getIntervals()) {
            if (interval.getStart() != (long)start || interval.getEnd() != (long)end) continue;
            return true;
        }
        return false;
    }
}

